/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.projectiles.LunargradeSpit;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoonLunargradeEntity
extends Monster
implements GeoAnimatable,
RangedAttackMob {
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    boolean didSpit;
    int spitTimer = 0;

    public MoonLunargradeEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<MoonLunargradeEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.spitTimer != 0)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.spitTimer > 0) {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("spit", Animation.LoopType.PLAY_ONCE));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 20.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new LunargradeHurtByTargetGoal(this));
    }

    void setDidSpit(boolean bool) {
        this.didSpit = bool;
    }

    public static boolean lunargradeSpawnRules(EntityType<MoonLunargradeEntity> lunargrade, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        BlockState state = level.m_8055_(pos.m_7495_());
        if (level.m_45976_(Monster.class, new AABB(pos).m_82400_(92.0)).size() >= 24) {
            return false;
        }
        if (pos.m_123342_() >= surfaceY) {
            return false;
        }
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_MOON_BLOCKS.tag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.MOON_LUNARGRADE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MOON_LUNARGRADE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.MOON_LUNARGRADE_DIE.get();
    }

    private void spit(LivingEntity pTarget) {
        LunargradeSpit lunargradespit = new LunargradeSpit(this.m_9236_(), this);
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - lunargradespit.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        lunargradespit.m_6686_(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        this.m_9236_().m_7967_((Entity)lunargradespit);
        this.didSpit = true;
        this.spitTimer = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
    }

    public void m_6504_(LivingEntity target, float dist) {
        this.spit(target);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.spitTimer > 0) {
            this.spitTimer = Mth.m_14045_((int)this.spitTimer, (int)0, (int)(this.spitTimer - 1));
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.spitTimer = 10;
        }
        super.m_7822_(pId);
    }

    static class LunargradeHurtByTargetGoal
    extends HurtByTargetGoal {
        public LunargradeHurtByTargetGoal(MoonLunargradeEntity lunargrade) {
            super((PathfinderMob)lunargrade, new Class[0]);
        }

        public boolean m_8045_() {
            Mob mob = this.f_26135_;
            if (mob instanceof MoonLunargradeEntity) {
                MoonLunargradeEntity lunargrade = (MoonLunargradeEntity)mob;
                if (lunargrade.didSpit) {
                    lunargrade.setDidSpit(false);
                    return false;
                }
            }
            return super.m_8045_();
        }
    }
}

