/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.particle.NorthstarParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoonSnailEntity
extends Monster
implements GeoAnimatable {
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int slimeTimer = this.f_19796_.m_188503_(6000) + 6000;

    public MoonSnailEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<MoonSnailEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.05f) || !(event.getLimbSwingAmount() < 0.05f)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_() && this.f_19797_ % 4 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)NorthstarParticles.SNAIL_SLIME.get(), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.slimeTimer > 0) {
            this.slimeTimer = Mth.m_14045_((int)this.slimeTimer, (int)0, (int)(this.slimeTimer - 1));
        } else if (!this.m_9236_().f_46443_ && !this.m_21224_() && this.slimeTimer <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)Items.f_42518_);
            this.m_146850_(GameEvent.f_157810_);
            this.slimeTimer = 6000;
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)NorthstarSounds.MOON_SNAIL_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        super.m_7975_(pDamageSource);
        return (SoundEvent)NorthstarSounds.MOON_SNAIL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return (SoundEvent)NorthstarSounds.MOON_SNAIL_DIE.get();
    }

    public static boolean snailSpawnRules(EntityType<MoonSnailEntity> snail, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        BlockState state = level.m_8055_(pos.m_7495_());
        if (level.m_45976_(Monster.class, new AABB(pos).m_82400_(92.0)).size() >= 24) {
            return false;
        }
        if (pos.m_123342_() >= surfaceY) {
            return false;
        }
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_MOON_BLOCKS.tag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("slimeTimer")) {
            this.slimeTimer = pCompound.m_128451_("slimeTimer");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("slimeTimer", this.slimeTimer);
    }
}

