/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class GravityStuffMixin {
    @Unique
    private static final double CONSTANT = 0.08;
    private static final double EARTH_GRAV = 1.0;
    private static final double MOON_GRAV = 0.16;
    private static final double OUTER_MOON_GRAV = 0.06;
    private static final double SUPER_GRAV = 4.0;
    private static final double MARS_GRAV = 0.37;
    private static final double VENUS_GRAV = 0.89;
    private static final double MERCURY_GRAV = 0.38;
    private static final double GANYMEDE_GRAV = 0.14;
    private static final double TITAN_GRAV = 0.14;
    private static final double EUROPA_GRAV = 0.13;
    double PLANET_GRAV = 1.0;
    private int fall_disabled = 0;

    @Inject(method={"travel"}, at={@At(value="TAIL")})
    public void northstar$travel(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (this.fall_disabled > 0) {
            --this.fall_disabled;
            entity.f_19789_ = 0.0f;
        }
        if (RocketHandler.isInRocket((Entity)entity) && entity.m_20186_() > 1500.0) {
            this.fall_disabled = 400;
        }
        Vec3 velocity = entity.m_20184_();
        boolean isInOrbit = NorthstarPlanets.isInOrbit((ResourceKey<Level>)entity.m_9236_().m_46472_());
        this.PLANET_GRAV = entity.m_9236_().m_46472_() == NorthstarDimensions.MARS_DIM_KEY ? 0.37 : (entity.m_9236_().m_46472_() == NorthstarDimensions.VENUS_DIM_KEY ? 0.89 : (entity.m_9236_().m_46472_() == NorthstarDimensions.MOON_DIM_KEY ? 0.16 : (entity.m_9236_().m_46472_() == NorthstarDimensions.MERCURY_DIM_KEY ? 0.38 : (isInOrbit ? 0.06 : 1.0))));
        if (entity.m_21255_() || entity.isInFluidType()) {
            this.PLANET_GRAV = 1.0;
        }
        if (!(entity.m_20068_() || entity.m_20069_() || entity.m_20077_() || entity.m_21023_(MobEffects.f_19591_))) {
            Player ply;
            float dust_push = 0.0f;
            if (entity.m_9236_().m_46722_(0.0f) > 0.0f && entity.m_9236_().m_45524_(entity.m_20183_(), -1) == 16 && !entity.m_5833_() && entity.m_9236_().m_46472_() == NorthstarDimensions.MARS_DIM_KEY && !NorthstarOxygen.hasOxygen(entity.m_9236_(), entity.m_146892_()) && entity.m_9236_().m_46739_(entity.m_20183_()) && !RocketHandler.isInRocket((Entity)entity)) {
                dust_push = 0.005f;
            }
            if (entity instanceof Player && (ply = (Player)entity).m_7500_()) {
                dust_push = 0.0f;
            }
            double newGrav = 0.08 * this.PLANET_GRAV;
            float crouchPush = 0.0f;
            if (!isInOrbit) {
                entity.m_20334_(velocity.m_7096_() + (double)dust_push, velocity.m_7098_() + (0.08 - newGrav), velocity.m_7094_() - (double)dust_push);
            } else {
                if (entity.m_6047_()) {
                    crouchPush = 0.05f;
                }
                float vel_y = (float)Mth.m_14008_((double)velocity.m_7098_(), (double)-0.3, (double)15.0);
                entity.m_20334_(velocity.m_7096_() + (double)dust_push, (double)vel_y + (0.08 - newGrav) - (double)crouchPush, velocity.m_7094_() - (double)dust_push);
            }
        }
    }

    @Inject(method={"calculateFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void calculateFallDamage(float pFallDistance, float pDamageMultiplier, CallbackInfoReturnable<Integer> info) {
        LivingEntity entity = (LivingEntity)this;
        if (!NorthstarPlanets.hasNormalGrav((ResourceKey<Level>)entity.m_9236_().m_46472_())) {
            MobEffectInstance mobeffectinstance = entity.m_21124_(MobEffects.f_19603_);
            double mult = this.getGravMultiplier((ResourceKey<Level>)entity.m_9236_().m_46472_());
            float f = (float)(mobeffectinstance == null ? 0.0 : (double)(mobeffectinstance.m_19564_() + 1) * mult);
            info.setReturnValue((Object)Mth.m_14165_((double)(((double)pFallDistance * mult - 3.0 - (double)f) * (double)pDamageMultiplier)));
        }
    }

    public double getGravMultiplier(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.16;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 0.37;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.38;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 0.89;
        }
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return 0.06;
        }
        return 1.0;
    }
}

