/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.accessor.NorthstarFluidState;
import com.lightning.northstar.world.sealer.SealingMode;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={FluidState.class})
public class FluidStateMixin
implements NorthstarFluidState {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void northstar$tick(Level level, BlockPos pos, CallbackInfo info) {
        this.northstar$onSealUpdated(level, pos, SealingMode.TEMPERATURE);
    }

    @Override
    public void northstar$onSealUpdated(Level level, BlockPos pos, SealingMode mode) {
        if (mode != SealingMode.TEMPERATURE) {
            return;
        }
        FluidState self = (FluidState)this;
        float temperature = NorthstarTemperature.getTemperatureAt(level, (Vec3i)pos);
        if (temperature >= (float)NorthstarTemperature.getBoilingPoint(self)) {
            BlockState block = level.m_8055_(pos);
            if (block.m_61138_((Property)BlockStateProperties.f_61362_) && !self.m_76178_()) {
                level.m_46597_(pos, (BlockState)block.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            } else {
                NorthstarTemperature.evaporate(level, pos);
            }
            return;
        }
        if (temperature <= (float)NorthstarTemperature.getFreezingPoint(self) && self.m_192917_((Fluid)Fluids.f_76193_)) {
            BlockState block = level.m_8055_(pos);
            if (block.m_61138_((Property)BlockStateProperties.f_61362_)) {
                level.m_46597_(pos, (BlockState)block.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            } else {
                level.m_46597_(pos, Blocks.f_50126_.m_49966_());
            }
            return;
        }
        if (NorthstarTemperature.isCombustible(self) && temperature >= (float)NorthstarTemperature.combustionTemp(self)) {
            this.northstar$combust(level, pos);
        }
    }

    @Unique
    public void northstar$combust(Level level, BlockPos pos) {
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        level.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.5f, true, Level.ExplosionInteraction.MOB);
    }
}

