/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.dimensionstuff;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    private static final ResourceLocation EARTH_CLOSE = Northstar.asResource("textures/environment/earth_close.png");
    private static final ResourceLocation EARTH_FAR = Northstar.asResource("textures/environment/earth_far.png");
    private static final ResourceLocation MOON_CLOSE = Northstar.asResource("textures/environment/moon_close.png");
    private static final ResourceLocation MOON_FAR = Northstar.asResource("textures/environment/moon_far.png");
    private static final ResourceLocation VENUS_FAR = Northstar.asResource("textures/environment/venus_far_sky.png");
    private static final ResourceLocation VENUS_CLOSE = Northstar.asResource("textures/environment/venus_close.png");
    private static final ResourceLocation BARE_SUN = Northstar.asResource("textures/environment/baresun.png");
    private static final ResourceLocation BLURRED_SUN = Northstar.asResource("textures/environment/sun_blurry.png");
    private static final ResourceLocation MARS_CLOSE = Northstar.asResource("textures/environment/mars_close.png");
    private static final ResourceLocation MARS_VERY_FAR = Northstar.asResource("textures/environment/mars_very_far_sky.png");
    private static final ResourceLocation MERCURY_CLOSE = Northstar.asResource("textures/environment/mercury_close.png");
    private static final ResourceLocation PHOBOS_DEIMOS = Northstar.asResource("textures/environment/phobos_and_deimos.png");
    private static final ResourceLocation NORTHERN_STAR = Northstar.asResource("textures/environment/northernstar_sky.png");
    private static final ResourceLocation MARS_DUST = Northstar.asResource("textures/environment/mars_dust.png");
    private static final ResourceLocation ACID_RAIN = Northstar.asResource("textures/environment/acid_rain.png");
    private static final ResourceLocation MOON_LOC = ResourceLocation.parse((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation CLOUDS_LOCATION = ResourceLocation.parse((String)"textures/environment/clouds.png");
    private static final ResourceLocation SNOW_LOCATION = ResourceLocation.parse((String)"textures/environment/snow.png");
    @Nullable
    private VertexBuffer darkBuffer;
    @Shadow
    private VertexBuffer f_109472_;
    @Shadow
    private VertexBuffer f_109471_;
    private VertexBuffer starBuffer2;
    private VertexBuffer starBuffer3;
    @Nullable
    @Shadow
    private VertexBuffer f_109475_;
    @Nullable
    private VertexBuffer cloudBuffer2;
    private boolean generateClouds = true;
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.f_82478_;
    @Nullable
    private CloudStatus prevCloudsType;
    @Nullable
    @Shadow
    private ClientLevel f_109465_;
    @Final
    @Shadow
    private Minecraft f_109461_;
    private float f_alpha = 1.0f;
    private int ticks;
    private int rainSoundTime;
    private double dust_bounce = 0.01;
    float sc = 1.0f;
    private static final Vector3f VENUS_DIFFUSE_1 = (Vector3f)Util.m_137469_((Object)new Vector3f(0.2f, -1.0f, -0.7f), Vector3f::normalize);
    private static final Vector3f VENUS_DIFFUSE_2 = (Vector3f)Util.m_137469_((Object)new Vector3f(-0.2f, -1.0f, 0.7f), Vector3f::normalize);
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderWeather(LightTexture pLightTexture, float pPartialTick, double pCamX, double pCamY, double pCamZ, CallbackInfo info) {
        float rain_det;
        float playerEyeLevel;
        if (this.f_109461_ != null && (playerEyeLevel = (float)this.f_109461_.f_91074_.m_146892_().f_82480_) > 450.0f) {
            info.cancel();
            return;
        }
        ResourceKey player_dim = Minecraft.m_91087_().f_91073_.m_46472_();
        if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
            info.cancel();
            rain_det = this.f_109461_.f_91073_.m_46722_(pPartialTick);
            if (!(rain_det <= 0.0f)) {
                pLightTexture.m_109896_();
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Camera pCamera = Minecraft.m_91087_().f_91063_.m_109153_();
                GameRenderer gRenderer = Minecraft.m_91087_().f_91063_;
                Vec3 vec3 = pCamera.m_90583_();
                double fog_x = vec3.m_7096_();
                double fog_y = vec3.m_7098_();
                FogRenderer.m_109018_((Camera)pCamera, (float)pPartialTick, (ClientLevel)this.f_109461_.f_91073_, (int)this.f_109461_.f_91066_.m_193772_(), (float)gRenderer.m_109131_(pPartialTick));
                FogRenderer.m_109036_();
                boolean flag2 = this.f_109461_.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)fog_x), Mth.m_14107_((double)fog_y)) || this.f_109461_.f_91065_.m_93090_().m_93715_();
                FogRenderer.m_234172_((Camera)pCamera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)(this.f_109461_.f_91066_.m_193772_() / 5), (boolean)flag2, (float)pPartialTick);
                FogRenderer.m_109017_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
                pLightTexture.m_109896_();
                ClientLevel level = this.f_109461_.f_91073_;
                int i = Mth.m_14107_((double)pCamX);
                int j = Mth.m_14107_((double)pCamY);
                int k = Mth.m_14107_((double)pCamZ);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                int l = 2;
                if (Minecraft.m_91405_()) {
                    l = 3;
                }
                RenderSystem.depthMask((boolean)Minecraft.m_91085_());
                int i1 = -1;
                float f1 = (float)this.ticks + pPartialTick;
                RenderSystem.setShader(GameRenderer::m_172829_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int j1 = k - l; j1 <= k + l; ++j1) {
                    for (int k1 = i - l; k1 <= i + l; ++k1) {
                        int l1 = (j1 - k + 8) * 32 + k1 - i + 8;
                        double d0 = (double)this.rainSizeX[l1] * 1.25;
                        double d1 = (double)this.rainSizeZ[l1] * 1.25;
                        blockpos$mutableblockpos.m_122169_((double)k1, pCamY, (double)j1);
                        Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                        if (biome.m_264600_((BlockPos)blockpos$mutableblockpos) != Biome.Precipitation.NONE) continue;
                        int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                        int j2 = j - l;
                        int k2 = j + l;
                        if (j2 < i2) {
                            j2 = i2;
                        }
                        if (k2 < i2) {
                            k2 = i2;
                        }
                        int l2 = i2;
                        if (i2 < j) {
                            l2 = j;
                        }
                        if (j2 == k2) continue;
                        RandomSource randomsource = RandomSource.m_216335_((long)(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761));
                        blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                        if (!biome.m_198906_((BlockPos)blockpos$mutableblockpos)) continue;
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_DUST);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = this.ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f2 = -((float)i3 + pPartialTick) / 32.0f * 0.75f;
                        this.dust_bounce = this.dust_bounce > 0.0 ? (this.dust_bounce -= 0.01) : (this.dust_bounce += 0.01);
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        RenderSystem.setShaderColor((float)2.0f, (float)1.178f, (float)0.698f, (float)0.5f);
                        int j3 = 0;
                        bufferbuilder.m_5483_((double)k1 - pCamX - d0 + -10.5, (double)k2 - pCamY, (double)j1 - pCamZ - d1 + 10.5).m_7421_(0.0f + f2, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.2f).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - pCamX + d0 + 10.5, (double)k2 - pCamY, (double)j1 - pCamZ + d1 + -10.5).m_7421_(1.0f + f2, (float)(0.0 + this.dust_bounce / 2.0)).m_85950_(1.0f, 1.0f, 1.0f, 0.2f).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - pCamX + d0 + 10.5, (double)j2 - pCamY, (double)j1 - pCamZ + d1 + -10.5).m_7421_(1.0f + f2, (float)(1.0 + this.dust_bounce / 2.0)).m_85950_(1.0f, 1.0f, 1.0f, 0.2f).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - pCamX - d0 + -10.5, (double)j2 - pCamY, (double)j1 - pCamZ - d1 + 10.5).m_7421_(0.0f + f2, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.2f).m_85969_(j3).m_5752_();
                    }
                }
                if (i1 >= 0) {
                    tesselator.m_85914_();
                }
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                pLightTexture.m_109891_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
            info.cancel();
            rain_det = this.f_109461_.f_91073_.m_46722_(pPartialTick);
            if (!(rain_det <= 0.0f)) {
                pLightTexture.m_109896_();
                ClientLevel level = this.f_109461_.f_91073_;
                int i = Mth.m_14107_((double)pCamX);
                int j = Mth.m_14107_((double)pCamY);
                int k = Mth.m_14107_((double)pCamZ);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                int l = 5;
                if (Minecraft.m_91405_()) {
                    l = 10;
                }
                RenderSystem.depthMask((boolean)Minecraft.m_91085_());
                int i1 = -1;
                RenderSystem.setShader(GameRenderer::m_172829_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int j1 = k - l; j1 <= k + l; ++j1) {
                    for (int k1 = i - l; k1 <= i + l; ++k1) {
                        int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                        double d0 = (double)this.rainSizeX[l1] * 0.5;
                        double d1 = (double)this.rainSizeZ[l1] * 0.5;
                        blockpos$mutableblockpos.m_122169_((double)k1, pCamY, (double)j1);
                        Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                        if (biome.m_264600_((BlockPos)blockpos$mutableblockpos) != Biome.Precipitation.NONE) continue;
                        int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                        int j2 = j - l;
                        int k2 = j + l;
                        if (j2 < i2) {
                            j2 = i2;
                        }
                        if (k2 < i2) {
                            k2 = i2;
                        }
                        int l2 = i2;
                        if (i2 < j) {
                            l2 = j;
                        }
                        if (j2 == k2) continue;
                        RandomSource randomsource = RandomSource.m_216335_((long)(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761));
                        blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                        if (!biome.m_198906_((BlockPos)blockpos$mutableblockpos)) continue;
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ACID_RAIN);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = this.ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f2 = -((float)i3 + pPartialTick) / 32.0f * (3.0f + randomsource.m_188501_());
                        double d2 = (double)k1 + 0.5 - pCamX;
                        double d4 = (double)j1 + 0.5 - pCamZ;
                        float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * rain_det;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        bufferbuilder.m_5483_((double)k1 - pCamX - d0 + 0.5, (double)k2 - pCamY, (double)j1 - pCamZ - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - pCamX + d0 + 0.5, (double)k2 - pCamY, (double)j1 - pCamZ + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - pCamX + d0 + 0.5, (double)j2 - pCamY, (double)j1 - pCamZ + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - pCamX - d0 + 0.5, (double)j2 - pCamY, (double)j1 - pCamZ - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                    }
                }
                if (i1 >= 0) {
                    tesselator.m_85914_();
                }
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                pLightTexture.m_109891_();
            }
        }
    }

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickRain(Camera pCamera, CallbackInfo info) {
        double d4;
        double d3;
        double d2;
        VoxelShape voxelshape;
        FluidState fluidstate;
        BlockState blockstate;
        double d1;
        double d0;
        Biome biome;
        BlockPos blockpos2;
        int l;
        int k;
        int j;
        int i;
        BlockPos blockpos1;
        BlockPos blockpos;
        ClientLevel levelreader;
        RandomSource randomsource;
        float rain_det;
        float playerEyeLevel;
        if (this.f_109461_ != null && (playerEyeLevel = (float)this.f_109461_.f_91074_.m_146892_().f_82480_) > 450.0f) {
            info.cancel();
            return;
        }
        ResourceKey player_dim = Minecraft.m_91087_().f_91073_.m_46472_();
        if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
            info.cancel();
            rain_det = this.f_109461_.f_91073_.m_46722_(3.0f);
            if (this.f_109465_.f_46441_.m_188503_(2) == 0 && this.f_109465_.m_46461_()) {
                BlockPos newpos = this.f_109465_.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(pCamera.m_90588_().m_123341_() + this.f_109465_.f_46441_.m_216332_(-64, 64), 0, pCamera.m_90588_().m_123343_() + this.f_109465_.f_46441_.m_216332_(-64, 64)));
                this.f_109465_.m_5776_();
                this.f_109465_.m_7107_((ParticleOptions)NorthstarParticles.DUST_CLOUD.get(), (double)newpos.m_123341_(), (double)(newpos.m_123342_() + this.f_109465_.f_46441_.m_188503_(3)), (double)newpos.m_123343_(), 0.0, 0.0, 0.0);
            }
            if (!(rain_det <= 0.0f)) {
                if (this.f_109465_.m_104583_().tickRain(this.f_109465_, this.ticks, pCamera)) {
                    return;
                }
                float f = this.f_109461_.f_91073_.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
                if (!(f <= 0.0f)) {
                    randomsource = RandomSource.m_216335_((long)((long)this.ticks * 312987231L));
                    levelreader = this.f_109461_.f_91073_;
                    blockpos = new BlockPos((Vec3i)pCamera.m_90588_());
                    blockpos1 = null;
                    i = (int)(100.0f * f * f) / (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
                    for (j = 0; j < i; ++j) {
                        k = randomsource.m_188503_(21) - 10;
                        l = randomsource.m_188503_(21) - 10;
                        blockpos2 = levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos.m_7918_(k, 0, l));
                        biome = (Biome)levelreader.m_204166_(blockpos2).m_203334_();
                        if (blockpos2.m_123342_() <= levelreader.m_141937_() || blockpos2.m_123342_() > blockpos.m_123342_() + 10 || blockpos2.m_123342_() < blockpos.m_123342_() - 10 || biome.m_264600_(blockpos2) != Biome.Precipitation.NONE || !biome.m_198906_(blockpos2)) continue;
                        blockpos1 = blockpos2.m_7495_();
                        if (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
                        d0 = randomsource.m_188500_();
                        d1 = randomsource.m_188500_();
                        blockstate = levelreader.m_8055_(blockpos1);
                        fluidstate = levelreader.m_6425_(blockpos1);
                        voxelshape = blockstate.m_60812_((BlockGetter)levelreader, blockpos1);
                        d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                        d3 = fluidstate.m_76155_((BlockGetter)levelreader, blockpos1);
                        d4 = Math.max(d2, d3);
                        if (this.f_109465_.f_46441_.m_188503_(10) != 0) continue;
                        this.f_109461_.f_91073_.m_7106_((ParticleOptions)NorthstarParticles.DUST_CLOUD.get(), (double)blockpos1.m_123341_() + d0, (double)blockpos1.m_123342_() + d4 + (double)this.f_109465_.f_46441_.m_188503_(4), (double)blockpos1.m_123343_() + d1, 0.0, 0.0, 0.0);
                    }
                    if (blockpos1 != null && randomsource.m_188503_(80) < this.rainSoundTime++) {
                        this.rainSoundTime = 0;
                        if (blockpos1.m_123342_() > blockpos.m_123342_() + 1 && levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() > Mth.m_14143_((float)blockpos.m_123342_())) {
                            this.f_109461_.f_91073_.m_245747_(blockpos1, (SoundEvent)NorthstarSounds.MARTIAN_DUST_STORM_ABOVE.get(), SoundSource.WEATHER, 0.5f, 0.5f, false);
                        } else {
                            this.f_109461_.f_91073_.m_245747_(blockpos1, (SoundEvent)NorthstarSounds.MARTIAN_DUST_STORM.get(), SoundSource.WEATHER, 1.0f, 1.0f, false);
                        }
                    }
                }
            }
        }
        if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
            info.cancel();
            rain_det = this.f_109461_.f_91073_.m_46722_(3.0f);
            if (!(rain_det <= 0.0f)) {
                if (this.f_109465_.m_104583_().tickRain(this.f_109465_, this.ticks, pCamera)) {
                    return;
                }
                float f = this.f_109461_.f_91073_.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
                if (!(f <= 0.0f)) {
                    randomsource = RandomSource.m_216335_((long)((long)this.ticks * 312987231L));
                    levelreader = this.f_109461_.f_91073_;
                    blockpos = new BlockPos((Vec3i)pCamera.m_90588_());
                    blockpos1 = null;
                    i = (int)(100.0f * f * f) / (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
                    for (j = 0; j < i; ++j) {
                        k = randomsource.m_188503_(21) - 10;
                        l = randomsource.m_188503_(21) - 10;
                        blockpos2 = levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos.m_7918_(k, 0, l));
                        biome = (Biome)levelreader.m_204166_(blockpos2).m_203334_();
                        if (blockpos2.m_123342_() <= levelreader.m_141937_() || blockpos2.m_123342_() > blockpos.m_123342_() + 10 || blockpos2.m_123342_() < blockpos.m_123342_() - 10 || biome.m_264600_(blockpos2) != Biome.Precipitation.NONE || !biome.m_198906_(blockpos2)) continue;
                        blockpos1 = blockpos2.m_7495_();
                        if (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
                        d0 = randomsource.m_188500_();
                        d1 = randomsource.m_188500_();
                        blockstate = levelreader.m_8055_(blockpos1);
                        fluidstate = levelreader.m_6425_(blockpos1);
                        voxelshape = blockstate.m_60812_((BlockGetter)levelreader, blockpos1);
                        d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                        d3 = fluidstate.m_76155_((BlockGetter)levelreader, blockpos1);
                        d4 = Math.max(d2, d3);
                        SimpleParticleType particleoptions = ParticleTypes.f_123762_;
                        this.f_109461_.f_91073_.m_7106_((ParticleOptions)particleoptions, (double)blockpos1.m_123341_() + d0, (double)blockpos1.m_123342_() + d4, (double)blockpos1.m_123343_() + d1, 0.0, 0.0, 0.0);
                    }
                    if (blockpos1 != null && randomsource.m_188503_(3) < this.rainSoundTime++) {
                        this.rainSoundTime = 0;
                        if (blockpos1.m_123342_() > blockpos.m_123342_() + 1 && levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() > Mth.m_14143_((float)blockpos.m_123342_())) {
                            this.f_109461_.f_91073_.m_245747_(blockpos1, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        } else {
                            this.f_109461_.f_91073_.m_245747_(blockpos1, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"createStars"}, at={@At(value="TAIL")})
    private void createStars(CallbackInfo ci) {
        Tesselator tesselator2 = Tesselator.m_85913_();
        BufferBuilder bufferbuilder2 = tesselator2.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer2 != null) {
            this.starBuffer2.close();
        }
        this.starBuffer2 = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer2 = this.drawStars2(bufferbuilder2);
        this.starBuffer2.m_85921_();
        this.starBuffer2.m_231221_(bufferbuilder$renderedbuffer2);
        VertexBuffer.m_85931_();
        Tesselator tesselator3 = Tesselator.m_85913_();
        BufferBuilder bufferbuilder3 = tesselator3.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer3 != null) {
            this.starBuffer3.close();
        }
        this.starBuffer3 = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer3 = this.drawStars3(bufferbuilder3);
        this.starBuffer3.m_85921_();
        this.starBuffer3.m_231221_(bufferbuilder$renderedbuffer3);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawStars2(BufferBuilder pBuilder) {
        RandomSource randomsource = RandomSource.m_216335_((long)92410L);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 2500; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                pBuilder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return pBuilder.m_231175_();
    }

    private BufferBuilder.RenderedBuffer drawStars3(BufferBuilder pBuilder) {
        RandomSource randomsource = RandomSource.m_216335_((long)64094L);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1800; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                pBuilder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return pBuilder.m_231175_();
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSky(PoseStack pPoseStack, Matrix4f pProjectionMatrix, float pPartialTick, Camera camera, boolean thing, Runnable runnable, CallbackInfo info) {
        ResourceKey player_dim = Minecraft.m_91087_().f_91073_.m_46472_();
        if (this.f_109461_ != null) {
            float starBrightness;
            float f;
            float playerEyeLevel;
            ShaderInstance shaderinstance;
            float f2;
            float f1;
            float f3;
            BufferBuilder bufferbuilder;
            float rain_det = 0.0f;
            if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
                info.cancel();
                runnable.run();
                bufferbuilder = Tesselator.m_85913_().m_85915_();
                Vec3 vec3 = this.f_109465_.m_171660_(this.f_109461_.f_91063_.m_109153_().m_90583_(), pPartialTick);
                float playerEyeLevel2 = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
                f3 = (float)vec3.f_82479_;
                f1 = (float)vec3.f_82480_;
                f2 = (float)vec3.f_82481_;
                if (playerEyeLevel2 > 400.0f) {
                    f3 = (float)(vec3.f_82479_ - (double)((playerEyeLevel2 - 400.0f) / 300.0f));
                    f1 = (float)(vec3.f_82480_ - (double)((playerEyeLevel2 - 400.0f) / 300.0f));
                    f2 = (float)(vec3.f_82481_ - (double)((playerEyeLevel2 - 400.0f) / 300.0f));
                    this.f_alpha = 1.0f - (playerEyeLevel2 - 400.0f) / 300.0f;
                    if (this.f_alpha < 0.0f) {
                        this.f_alpha = 0.0f;
                    }
                } else {
                    this.f_alpha = 1.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f3, (float)f1, (float)f2, (float)this.f_alpha);
                shaderinstance = RenderSystem.getShader();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance);
                VertexBuffer.m_85931_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float SUN = 20.0f;
                float PD = 15.0f;
                if (!(rain_det <= 0.0f)) {
                    if ((double)this.sc > 0.45) {
                        this.sc = (float)((double)this.sc - 0.01);
                    }
                } else if (!(this.sc <= 1.0f)) {
                    this.sc = (float)((double)this.sc + 0.01);
                }
                RenderSystem.setShaderColor((float)this.sc, (float)this.sc, (float)this.sc, (float)1.0f);
                VertexBuffer.m_85931_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float[] afloat = this.f_109465_.m_104583_().m_7518_(this.f_109465_.m_46942_(pPartialTick), pPartialTick);
                if (afloat != null) {
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    pPoseStack.m_85836_();
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    float f32 = Mth.m_14031_((float)this.f_109465_.m_46490_(pPartialTick)) < 0.0f ? 180.0f : 0.0f;
                    pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f32));
                    pPoseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                    float f4 = afloat[0];
                    float f5 = afloat[1];
                    float f6 = afloat[2];
                    Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                    bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
                    for (int j = 0; j <= 16; ++j) {
                        float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                        float f8 = Mth.m_14031_((float)f7);
                        float f9 = Mth.m_14089_((float)f7);
                        bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                    }
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                    pPoseStack.m_85849_();
                }
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                Matrix4f matrix4f1 = pPoseStack.m_85850_().m_252922_();
                float rain_det2 = this.f_109461_.f_91073_.m_46722_(pPartialTick);
                float f10 = 2.0f;
                if (!(rain_det2 <= 0.0f) && playerEyeLevel2 <= 450.0f) {
                    f10 = 0.0f;
                }
                if (f10 > 0.0f) {
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)0.67f);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)0.33f);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                }
                float sky_brightness = (float)((double)this.f_109465_.m_104811_(pPartialTick) * 1.5) * (float)(!this.f_109465_.m_46471_() || !(playerEyeLevel2 < 450.0f) ? 1 : 0);
                float f11 = 1.0f - this.f_109465_.m_46722_(pPartialTick);
                if (playerEyeLevel2 > 400.0f) {
                    f11 += (playerEyeLevel2 - 400.0f) / 200.0f;
                    f11 = Mth.m_14036_((float)f11, (float)0.0f, (float)1.0f);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)PHOBOS_DEIMOS);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, 10.0f + PD, -100.0f, 5.0f + -PD).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 10.0f + -PD, -100.0f, 5.0f + -PD).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 10.0f + -PD, -100.0f, 5.0f + PD).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 10.0f + PD, -100.0f, 5.0f + PD).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, SUN, 100.0f, SUN).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -SUN, 100.0f, SUN).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -SUN, 100.0f, -SUN).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, SUN, 100.0f, -SUN).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.setShaderColor((float)sky_brightness, (float)sky_brightness, (float)sky_brightness, (float)1.0f);
                float EF = 3.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_FAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -40.0f + EF, 50.0f + EF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -39.0f + EF, 50.0f + -EF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -39.0f + -EF, 50.0f + -EF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -40.0f + -EF, 50.0f + EF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float MF = 1.5f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_FAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -40.0f + MF, 55.0f + MF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -39.5f + MF, 55.0f + -MF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -39.5f + -MF, 55.0f + -MF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -40.0f + -MF, 55.0f + MF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float NS = 2.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f + -NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f + -NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float VF = 2.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -58.75f, -30.0f + VF, -80.0f + -VF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -60.0f, -29.25f + VF, -80.0f + VF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -60.0f, -29.25f + -VF, -80.0f + VF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -58.75f, -30.0f + -VF, -80.0f + -VF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.depthMask((boolean)true);
                pPoseStack.m_85849_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                float mars_alpha = (playerEyeLevel2 - 400.0f) / 100.0f;
                float mars_dist = (playerEyeLevel2 - 400.0f) / 10.0f;
                if (playerEyeLevel2 > 400.0f) {
                    float MC = 1500.0f;
                    if (playerEyeLevel2 > 650.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    Matrix4f matrix4f2 = pPoseStack.m_85850_().m_252922_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)mars_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_CLOSE);
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder.m_252986_(matrix4f2, MC, -100.0f - mars_dist, -MC).m_7421_(0.0f, 0.0f).m_5752_();
                    bufferbuilder.m_252986_(matrix4f2, -MC, -100.0f - mars_dist, -MC).m_7421_(1.0f, 0.0f).m_5752_();
                    bufferbuilder.m_252986_(matrix4f2, -MC, -100.0f - mars_dist, MC).m_7421_(1.0f, 1.0f).m_5752_();
                    bufferbuilder.m_252986_(matrix4f2, MC, -100.0f - mars_dist, MC).m_7421_(0.0f, 1.0f).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                pPoseStack.m_85849_();
            }
            if (player_dim == Level.f_46428_ && (playerEyeLevel = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_) > 450.0f) {
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = Tesselator.m_85913_().m_85915_();
                Vec3 vec3 = this.f_109465_.m_171660_(this.f_109461_.f_91063_.m_109153_().m_90583_(), pPartialTick);
                f3 = (float)vec3.f_82479_;
                f1 = (float)vec3.f_82480_;
                f2 = (float)vec3.f_82481_;
                if (playerEyeLevel > 450.0f) {
                    f3 = (float)(vec3.f_82479_ - (double)((playerEyeLevel - 450.0f) / 300.0f));
                    f1 = (float)(vec3.f_82480_ - (double)((playerEyeLevel - 450.0f) / 300.0f));
                    f2 = (float)(vec3.f_82481_ - (double)((playerEyeLevel - 450.0f) / 300.0f));
                    this.f_alpha = 1.0f - (playerEyeLevel - 450.0f) / 300.0f;
                    if (this.f_alpha < 0.0f) {
                        this.f_alpha = 0.0f;
                    }
                } else {
                    this.f_alpha = 1.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f3, (float)f1, (float)f2, (float)this.f_alpha);
                shaderinstance = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance);
                VertexBuffer.m_85931_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.m_85850_().m_252922_();
                float f10 = this.f_109465_.m_104811_(pPartialTick);
                float starBrightness2 = f10 > 0.0f ? -(f10 - (playerEyeLevel - 300.0f) / 100.0f) : (playerEyeLevel - 450.0f) / 200.0f;
                float starBrightness22 = f10 > 0.0f ? (playerEyeLevel - 450.0f) / 200.0f : (playerEyeLevel - 600.0f) / 200.0f;
                float starBrightness3 = f10 > 0.0f ? (playerEyeLevel - 600.0f) / 300.0f : (playerEyeLevel - 700.0f) / 200.0f;
                starBrightness22 = Mth.m_14036_((float)starBrightness22, (float)0.0f, (float)0.67f);
                starBrightness3 = Mth.m_14036_((float)starBrightness22, (float)0.0f, (float)0.33f);
                if (starBrightness2 > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness2, (float)starBrightness2, (float)starBrightness2, (float)(starBrightness2 / 2.0f));
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness2, (float)starBrightness2, (float)starBrightness2, (float)starBrightness22);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness2, (float)starBrightness2, (float)starBrightness2, (float)starBrightness3);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                }
                BufferBuilder bufferbuilder_earth_sky = Tesselator.m_85913_().m_85915_();
                Matrix4f matrix4f_earth_sky = pPoseStack.m_85850_().m_252922_();
                float earth_sky_planet_brightness = (float)((double)this.f_109465_.m_104811_(pPartialTick) * 1.5) * (float)(!this.f_109465_.m_46471_() || !(playerEyeLevel < 450.0f) ? 1 : 0);
                float northstar_brightness = earth_sky_planet_brightness * 2.0f;
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder_earth_sky.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f + -NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f + -NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder_earth_sky.m_231175_());
                if (playerEyeLevel >= 450.0f) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness);
                }
                float VF = 2.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder_earth_sky.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -40.0f + VF, 50.0f + VF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -39.4f + VF, 50.0f - VF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -39.4f - VF, 50.0f - VF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -40.0f - VF, 50.0f + VF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder_earth_sky.m_231175_());
                float MVF = 1.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder_earth_sky.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -59.25f, -30.0f + MVF, -80.0f - MVF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -60.0f, -29.65f + MVF, -80.0f + MVF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -60.0f, -29.65f - MVF, -80.0f + MVF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -59.25f, -30.0f - MVF, -80.0f - MVF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder_earth_sky.m_231175_());
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f11 = 1.0f - this.f_109465_.m_46722_(pPartialTick);
                if (playerEyeLevel > 400.0f) {
                    f11 += (playerEyeLevel - 400.0f) / 200.0f;
                    f11 = Mth.m_14036_((float)f11, (float)0.0f, (float)1.0f);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                f12 = 20.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOC);
                int k = this.f_109465_.m_46941_();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)(l + 0) / 4.0f;
                float f14 = (float)(i1 + 0) / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.enableDepthTest();
                pPoseStack.m_85849_();
                float earth_alpha = (playerEyeLevel - 450.0f) / 300.0f;
                float earth_dist = (playerEyeLevel - 450.0f) / 10.0f;
                if (playerEyeLevel > 450.0f) {
                    if (earth_alpha >= 1.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    float EC = 2000.0f;
                    pPoseStack.m_85836_();
                    pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                    Matrix4f matrix4f2 = pPoseStack.m_85850_().m_252922_();
                    BufferBuilder bufferbuilder2 = Tesselator.m_85913_().m_85915_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)earth_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_CLOSE);
                    bufferbuilder2.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, -EC).m_7421_(0.0f, 0.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, -EC).m_7421_(1.0f, 0.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, EC).m_7421_(1.0f, -1.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, EC).m_7421_(0.0f, -1.0f).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder2.m_231175_());
                }
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                pPoseStack.m_85849_();
            }
            if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
                info.cancel();
                runnable.run();
                bufferbuilder = Tesselator.m_85913_().m_85915_();
                float time = this.f_109465_.m_46942_(pPartialTick);
                float skydarken = Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.5f;
                Vec3 skycolor = new Vec3(1.0, (double)0.874f, (double)0.336f);
                skydarken = Mth.m_14036_((float)skydarken, (float)0.125f, (float)1.0f);
                float playerEyeLevel3 = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
                float f4 = (float)skycolor.f_82479_ * skydarken;
                float f12 = (float)skycolor.f_82480_ * skydarken;
                float f22 = (float)skycolor.f_82481_ * skydarken;
                if (playerEyeLevel3 > 600.0f) {
                    f4 = (float)(skycolor.f_82479_ * (double)skydarken - (double)((playerEyeLevel3 - 600.0f) / 300.0f));
                    f12 = (float)(skycolor.f_82480_ * (double)skydarken - (double)((playerEyeLevel3 - 600.0f) / 300.0f));
                    f22 = (float)(skycolor.f_82481_ * (double)skydarken - (double)((playerEyeLevel3 - 600.0f) / 300.0f));
                    this.f_alpha = 1.0f - (playerEyeLevel3 - 600.0f) / 300.0f;
                    if (this.f_alpha < 0.0f) {
                        this.f_alpha = 0.0f;
                    }
                } else {
                    this.f_alpha = 1.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f4, (float)f12, (float)f22, (float)this.f_alpha);
                ShaderInstance shaderinstance2 = RenderSystem.getShader();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance2);
                VertexBuffer.m_85931_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float SUN = 30.0f;
                if (!(rain_det <= 0.0f)) {
                    if ((double)this.sc > 0.45) {
                        this.sc = (float)((double)this.sc - 0.01);
                    }
                } else if (!(this.sc <= 1.0f)) {
                    this.sc = (float)((double)this.sc + 0.01);
                }
                RenderSystem.setShaderColor((float)this.sc, (float)this.sc, (float)this.sc, (float)1.0f);
                VertexBuffer.m_85931_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float[] afloat = this.f_109465_.m_104583_().m_7518_(this.f_109465_.m_46942_(pPartialTick), pPartialTick);
                if (afloat != null) {
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    pPoseStack.m_85836_();
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    float f33 = Mth.m_14031_((float)this.f_109465_.m_46490_(pPartialTick)) < 0.0f ? 180.0f : 0.0f;
                    pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f33));
                    pPoseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                    float f42 = afloat[0];
                    float f5 = afloat[1];
                    float f6 = afloat[2];
                    Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                    bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f42, f5, f6, afloat[3]).m_5752_();
                    for (int j = 0; j <= 16; ++j) {
                        float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                        float f8 = Mth.m_14031_((float)f7);
                        float f9 = Mth.m_14089_((float)f7);
                        bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                    }
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                    pPoseStack.m_85849_();
                }
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                Matrix4f matrix4f1 = pPoseStack.m_85850_().m_252922_();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLURRED_SUN);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, SUN, 100.0f, SUN).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -SUN, 100.0f, SUN).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -SUN, 100.0f, -SUN).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, SUN, 100.0f, -SUN).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float sun_alpha = (playerEyeLevel3 - 600.0f) / 300.0f;
                sun_alpha = Mth.m_14036_((float)sun_alpha, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)sun_alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, SUN, 100.0f, SUN).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -SUN, 100.0f, SUN).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -SUN, 100.0f, -SUN).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, SUN, 100.0f, -SUN).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float f11 = 0.5f - this.f_109465_.m_46722_(pPartialTick);
                float f10 = this.f_109465_.m_104811_(pPartialTick) * f11;
                float starHeight = (playerEyeLevel3 - 600.0f) / 300.0f;
                if (!(playerEyeLevel3 <= 600.0f)) {
                    f10 += starHeight;
                }
                float starBrightness3 = (f10 = Mth.m_14036_((float)f10, (float)0.0f, (float)2.0f)) > 0.0f ? (playerEyeLevel3 - 650.0f) / 100.0f : (playerEyeLevel3 - 675.0f) / 200.0f;
                float starBrightness2 = f10 > 0.0f ? (playerEyeLevel3 - 750.0f) / 200.0f : (playerEyeLevel3 - 750.0f) / 200.0f;
                float starBrightness32 = f10 > 0.0f ? (playerEyeLevel3 - 850.0f) / 300.0f : (playerEyeLevel3 - 850.0f) / 200.0f;
                starBrightness2 = Mth.m_14036_((float)starBrightness2, (float)0.0f, (float)0.67f);
                starBrightness32 = Mth.m_14036_((float)starBrightness2, (float)0.0f, (float)0.33f);
                if (f10 > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness3, (float)starBrightness3, (float)starBrightness3, (float)starBrightness3);
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness3, (float)starBrightness3, (float)starBrightness3, (float)starBrightness2);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness3, (float)starBrightness3, (float)starBrightness3, (float)starBrightness32);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                    runnable.run();
                }
                float planetBrightness = Mth.m_14036_((float)starBrightness3, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderColor((float)planetBrightness, (float)planetBrightness, (float)planetBrightness, (float)planetBrightness);
                float EF = 3.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_FAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -40.0f + EF, 50.0f + EF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -39.0f + EF, 50.0f - EF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -39.0f - EF, 50.0f - EF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, 100.0f, -40.0f - EF, 50.0f + EF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float NS = 2.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f - NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -100.0f, -30.0f - NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float MVF = 1.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -59.25f, -30.0f + MVF, -80.0f - MVF).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -60.0f, -29.65f + MVF, -80.0f + MVF).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -60.0f, -29.65f - MVF, -80.0f + MVF).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -59.25f, -30.0f - MVF, -80.0f - MVF).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.depthMask((boolean)true);
                pPoseStack.m_85849_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                float venus_alpha = (playerEyeLevel3 - 600.0f) / 150.0f;
                float venus_dist = (playerEyeLevel3 - 600.0f) / 10.0f;
                if (playerEyeLevel3 > 600.0f) {
                    float VC = 2000.0f;
                    if (playerEyeLevel3 > 750.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    Matrix4f matrix4f2 = pPoseStack.m_85850_().m_252922_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)venus_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_CLOSE);
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder.m_252986_(matrix4f2, VC, -100.0f - venus_dist, -VC).m_7421_(0.0f, 0.0f).m_5752_();
                    bufferbuilder.m_252986_(matrix4f2, -VC, -100.0f - venus_dist, -VC).m_7421_(1.0f, 0.0f).m_5752_();
                    bufferbuilder.m_252986_(matrix4f2, -VC, -100.0f - venus_dist, VC).m_7421_(1.0f, 1.0f).m_5752_();
                    bufferbuilder.m_252986_(matrix4f2, VC, -100.0f - venus_dist, VC).m_7421_(0.0f, 1.0f).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                pPoseStack.m_85849_();
            }
            if (player_dim == NorthstarDimensions.MOON_DIM_KEY) {
                float playerEyeLevel4 = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = Tesselator.m_85913_().m_85915_();
                f = 0.0f;
                float f13 = 0.0f;
                float f23 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f13, (float)f23, (float)this.f_alpha);
                ShaderInstance shaderinstance3 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance3);
                VertexBuffer.m_85931_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.m_85850_().m_252922_();
                float f10 = 2.0f;
                starBrightness = f10 > 0.0f ? -(f10 - playerEyeLevel4 - 300.0f) / 100.0f : (playerEyeLevel4 - 450.0f) / 200.0f;
                if (starBrightness > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.67f);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.33f);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                }
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f - NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f - NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int VF = 2;
                int MVF = 1;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -40.0f + (float)VF, (float)(50 + VF)).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -39.4f + (float)VF, (float)(50 - VF)).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -39.4f - (float)VF, (float)(50 - VF)).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -40.0f - (float)VF, (float)(50 + VF)).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -59.25f, -30.0f + (float)MVF, (float)(-80 - MVF)).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -60.0f, -29.65f + (float)MVF, (float)(-80 + MVF)).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -60.0f, -29.65f - (float)MVF, (float)(-80 + MVF)).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -59.25f, -30.0f - (float)MVF, (float)(-80 - MVF)).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                pPoseStack.m_85849_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f11 = 1.0f - this.f_109465_.m_46722_(pPartialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.disableBlend();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(-135.0f));
                Matrix4f matrix4f2 = pPoseStack.m_85850_().m_252922_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::m_172817_);
                float earth_sky_dist = 35.0f;
                float ECS = 45.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_CLOSE);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f2, ECS, -100.0f - earth_sky_dist, -ECS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f2, -ECS, -100.0f - earth_sky_dist, -ECS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f2, -ECS, -100.0f - earth_sky_dist, ECS).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f2, ECS, -100.0f - earth_sky_dist, ECS).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                pPoseStack.m_85849_();
                RenderSystem.depthMask((boolean)true);
                f12 = 20.0f;
                float earth_alpha = (playerEyeLevel4 - 450.0f) / 300.0f;
                float earth_dist = (playerEyeLevel4 - 450.0f) / 10.0f;
                if (playerEyeLevel4 > 450.0f) {
                    if (earth_alpha >= 1.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    float EC = 2000.0f;
                    pPoseStack.m_85836_();
                    pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                    matrix4f2 = pPoseStack.m_85850_().m_252922_();
                    BufferBuilder bufferbuilder2 = Tesselator.m_85913_().m_85915_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)earth_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_CLOSE);
                    bufferbuilder2.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, -EC).m_7421_(0.0f, 0.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, -EC).m_7421_(1.0f, 0.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, EC).m_7421_(1.0f, -1.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, EC).m_7421_(0.0f, -1.0f).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder2.m_231175_());
                    pPoseStack.m_85849_();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (player_dim == null) {
                float playerEyeLevel5 = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
                info.cancel();
                runnable.run();
                float f5 = 0.0f;
                float f14 = 0.0f;
                float f24 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f5, (float)f14, (float)f24, (float)this.f_alpha);
                ShaderInstance shaderinstance4 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance4);
                VertexBuffer.m_85931_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                float f10 = 2.0f;
                float starBrightness4 = f10 > 0.0f ? -(f10 - playerEyeLevel5 - 300.0f) / 100.0f : (playerEyeLevel5 - 450.0f) / 200.0f;
                if (starBrightness4 > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness4, (float)starBrightness4, (float)starBrightness4, (float)starBrightness4);
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness4, (float)starBrightness4, (float)starBrightness4, (float)0.67f);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness4, (float)starBrightness4, (float)starBrightness4, (float)0.33f);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (player_dim == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
                float playerEyeLevel6 = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = Tesselator.m_85913_().m_85915_();
                f = 0.0f;
                float f15 = 0.0f;
                float f25 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f15, (float)f25, (float)this.f_alpha);
                ShaderInstance shaderinstance5 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance5);
                VertexBuffer.m_85931_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.m_85850_().m_252922_();
                float f10 = 2.0f;
                starBrightness = f10 > 0.0f ? -(f10 - playerEyeLevel6 - 300.0f) / 100.0f : (playerEyeLevel6 - 450.0f) / 200.0f;
                if (starBrightness > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.67f);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.33f);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                }
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f - NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f - NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int VF = 2;
                int MVF = 1;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -40.0f + (float)VF, (float)(50 + VF)).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -39.4f + (float)VF, (float)(50 - VF)).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -39.4f - (float)VF, (float)(50 - VF)).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -40.0f - (float)VF, (float)(50 + VF)).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -59.25f, -30.0f + (float)MVF, (float)(-80 - MVF)).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -60.0f, -29.65f + (float)MVF, (float)(-80 + MVF)).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -60.0f, -29.65f - (float)MVF, (float)(-80 + MVF)).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -59.25f, -30.0f - (float)MVF, (float)(-80 - MVF)).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                pPoseStack.m_85849_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f11 = 1.0f - this.f_109465_.m_46722_(pPartialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.disableBlend();
                f12 = 20.0f;
                float earth_dist = 175.0f;
                float EC = 2000.0f;
                Matrix4f matrix4f2 = pPoseStack.m_85850_().m_252922_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                matrix4f2 = pPoseStack.m_85850_().m_252922_();
                BufferBuilder bufferbuilder2 = Tesselator.m_85913_().m_85915_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_CLOSE);
                bufferbuilder2.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, -EC).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, -EC).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, EC).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, EC).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder2.m_231175_());
                pPoseStack.m_85849_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.depthMask((boolean)true);
            }
            if (player_dim == NorthstarDimensions.MERCURY_DIM_KEY) {
                float playerEyeLevel7 = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = Tesselator.m_85913_().m_85915_();
                f = 0.0f;
                float f16 = 0.0f;
                float f26 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f16, (float)f26, (float)this.f_alpha);
                ShaderInstance shaderinstance6 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.f_109472_.m_85921_();
                this.f_109472_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance6);
                VertexBuffer.m_85931_();
                pPoseStack.m_85836_();
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.m_85850_().m_252922_();
                float f10 = 2.0f;
                starBrightness = f10 > 0.0f ? -(f10 - playerEyeLevel7 - 300.0f) / 100.0f : (playerEyeLevel7 - 450.0f) / 200.0f;
                if (starBrightness > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.m_109017_();
                    this.f_109471_.m_85921_();
                    this.f_109471_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.67f);
                    this.starBuffer2.m_85921_();
                    this.starBuffer2.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.33f);
                    this.starBuffer3.m_85921_();
                    this.starBuffer3.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    runnable.run();
                }
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f - NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -100.0f, -30.0f - NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int VF = 2;
                int EF = 2;
                int SUN = 80;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -40.0f + (float)VF, (float)(50 + VF)).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -39.4f + (float)VF, (float)(50 - VF)).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -39.4f - (float)VF, (float)(50 - VF)).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, 100.0f, -40.0f - (float)VF, (float)(50 + VF)).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_FAR);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -58.0f, -30.0f + (float)EF, (float)(-80 - EF)).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -60.0f, -29.65f + (float)EF, (float)(-80 + EF)).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -60.0f, -29.65f - (float)EF, (float)(-80 + EF)).m_7421_(1.0f, -1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -58.0f, -30.0f - (float)EF, (float)(-80 - EF)).m_7421_(0.0f, -1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, (float)SUN, 100.0f, (float)SUN).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, (float)(-SUN), 100.0f, (float)SUN).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, (float)(-SUN), 100.0f, (float)(-SUN)).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, (float)SUN, 100.0f, (float)(-SUN)).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                pPoseStack.m_85849_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f11 = 1.0f - this.f_109465_.m_46722_(pPartialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder3.m_252986_(matrix4f3, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder3.m_231175_());
                RenderSystem.disableBlend();
                Matrix4f matrix4f2 = pPoseStack.m_85850_().m_252922_();
                f12 = 20.0f;
                float earth_alpha = (playerEyeLevel7 - 450.0f) / 300.0f;
                float earth_dist = (playerEyeLevel7 - 450.0f) / 10.0f;
                if (playerEyeLevel7 > 450.0f) {
                    if (earth_alpha >= 1.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    float EC = 2000.0f;
                    pPoseStack.m_85836_();
                    pPoseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                    matrix4f2 = pPoseStack.m_85850_().m_252922_();
                    BufferBuilder bufferbuilder2 = Tesselator.m_85913_().m_85915_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)earth_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MERCURY_CLOSE);
                    bufferbuilder2.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, -EC).m_7421_(0.0f, 0.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, -EC).m_7421_(1.0f, 0.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, -EC, -100.0f - earth_dist, EC).m_7421_(1.0f, -1.0f).m_5752_();
                    bufferbuilder2.m_252986_(matrix4f2, EC, -100.0f - earth_dist, EC).m_7421_(0.0f, -1.0f).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder2.m_231175_());
                    pPoseStack.m_85849_();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getStarBrightness(F)F")})
    private void renderSkyStarsOverworld(PoseStack pPoseStack, Matrix4f pProjectionMatrix, float pPartialTick, Camera camera, boolean thing, Runnable runnable, CallbackInfo info) {
        if (this.f_109461_ == null) {
            return;
        }
        ResourceKey player_dim = Minecraft.m_91087_().f_91073_.m_46472_();
        if (player_dim != Level.f_46428_) {
            return;
        }
        float playerEyeLevel = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
        BufferBuilder bufferbuilder_earth_sky = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix4f_earth_sky = pPoseStack.m_85850_().m_252922_();
        float earth_sky_planet_brightness = this.f_109465_.m_104811_(pPartialTick) * 1.5f * (float)(!this.f_109465_.m_46471_() || !(playerEyeLevel < 450.0f) ? 1 : 0);
        float northstar_brightness = earth_sky_planet_brightness * 2.0f;
        float NS = 2.0f;
        RenderSystem.setShaderColor((float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
        bufferbuilder_earth_sky.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f + NS, -NS).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f + NS, NS).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f - NS, NS).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -100.0f, -30.0f - NS, -NS).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder_earth_sky.m_231175_());
        if (playerEyeLevel >= 450.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness);
        }
        float VF = 2.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
        bufferbuilder_earth_sky.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -40.0f + VF, 50.0f + VF).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -39.4f + VF, 50.0f - VF).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -39.4f - VF, 50.0f - VF).m_7421_(1.0f, -1.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, 100.0f, -40.0f - VF, 50.0f + VF).m_7421_(0.0f, -1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder_earth_sky.m_231175_());
        float MVF = 1.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
        bufferbuilder_earth_sky.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -59.25f, -30.0f + MVF, -80.0f - MVF).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -60.0f, -29.65f + MVF, -80.0f + MVF).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -60.0f, -29.65f - MVF, -80.0f + MVF).m_7421_(1.0f, -1.0f).m_5752_();
        bufferbuilder_earth_sky.m_252986_(matrix4f_earth_sky, -59.25f, -30.0f - MVF, -80.0f - MVF).m_7421_(0.0f, -1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder_earth_sky.m_231175_());
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(PoseStack pPoseStack, Matrix4f pProjectionMatrix, float pPartialTick, double pCamX, double pCamY, double pCamZ, CallbackInfo info) {
        ResourceKey player_dim = Minecraft.m_91087_().f_91073_.m_46472_();
        if (this.f_109461_ != null) {
            float playerEyeLevel = (float)this.f_109461_.f_91074_.m_20299_((float)pPartialTick).f_82480_;
            if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.MOON_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.MERCURY_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == Level.f_46428_ && playerEyeLevel > 500.0f) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.VENUS_DIM_KEY && !(playerEyeLevel > 500.0f)) {
                info.cancel();
                if (this.f_109465_.m_104583_().renderClouds(this.f_109465_, this.ticks, pPartialTick, pPoseStack, pCamX, pCamY, pCamZ, pProjectionMatrix)) {
                    return;
                }
                float f = this.f_109465_.m_104583_().m_108871_();
                if (!Float.isNaN(f)) {
                    RenderSystem.disableCull();
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.depthMask((boolean)true);
                    double d1 = ((float)this.ticks + pPartialTick) * 0.03f;
                    double d2 = (pCamX + d1) / 12.0;
                    double d3 = f - (float)pCamY + 0.33f;
                    double d4 = pCamZ / 12.0 + (double)0.33f;
                    d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
                    d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
                    float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
                    float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
                    float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
                    float time = this.f_109465_.m_46942_(pPartialTick);
                    float cloudcolor = Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.5f;
                    cloudcolor = Mth.m_14036_((float)cloudcolor, (float)0.25f, (float)1.0f);
                    Vec3 vec3 = new Vec3((double)(0.5058f * cloudcolor), (double)(0.5176f * cloudcolor), (double)(0.0352f * cloudcolor));
                    int i = (int)Math.floor(d2);
                    int j = (int)Math.floor(d3 / 4.0);
                    int k = (int)Math.floor(d4);
                    if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || this.f_109461_.f_91066_.m_92174_() != this.prevCloudsType || this.prevCloudColor.m_82557_(vec3) > 2.0E-4) {
                        this.prevCloudX = i;
                        this.prevCloudY = j;
                        this.prevCloudZ = k;
                        this.prevCloudColor = vec3;
                        this.prevCloudsType = this.f_109461_.f_91066_.m_92174_();
                        this.generateClouds = true;
                    }
                    if (this.generateClouds) {
                        this.generateClouds = false;
                        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                        if (this.f_109475_ != null) {
                            this.f_109475_.close();
                        }
                        this.f_109475_ = new VertexBuffer(VertexBuffer.Usage.STATIC);
                        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.buildClouds(bufferbuilder, d2, d3, d4, vec3, 1.0f);
                        this.f_109475_.m_85921_();
                        this.f_109475_.m_231221_(bufferbuilder$renderedbuffer);
                        VertexBuffer.m_85931_();
                    }
                    RenderSystem.setShader(GameRenderer::m_172838_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CLOUDS_LOCATION);
                    FogRenderer.m_109036_();
                    pPoseStack.m_85836_();
                    pPoseStack.m_85841_(12.0f, 1.0f, 12.0f);
                    pPoseStack.m_85837_((double)(-f3), (double)f4, (double)(-f5));
                    if (this.f_109475_ != null) {
                        int l;
                        this.f_109475_.m_85921_();
                        for (int i1 = l = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                            if (i1 == 0) {
                                RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                            } else {
                                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                            }
                            ShaderInstance shaderinstance = RenderSystem.getShader();
                            this.f_109475_.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance);
                        }
                        VertexBuffer.m_85931_();
                    }
                    pPoseStack.m_85849_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableCull();
                    RenderSystem.disableBlend();
                }
            } else if (player_dim == NorthstarDimensions.VENUS_DIM_KEY && playerEyeLevel > 500.0f) {
                info.cancel();
            }
        }
    }

    private BufferBuilder.RenderedBuffer buildClouds(BufferBuilder pBuilder, double pX, double pY, double pZ, Vec3 pCloudColor, float offset) {
        float f3 = (float)Mth.m_14107_((double)pX) * 0.00390625f;
        float f4 = (float)Mth.m_14107_((double)pZ) * 0.00390625f;
        float f5 = (float)pCloudColor.f_82479_;
        float f6 = (float)pCloudColor.f_82480_;
        float f7 = (float)pCloudColor.f_82481_;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        RenderSystem.setShader(GameRenderer::m_172838_);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float f17 = (float)Math.floor(pY / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                    if (f17 <= 5.0f) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
        } else {
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    pBuilder.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
            }
        }
        return pBuilder.m_231175_();
    }
}

