/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.level;

import com.lightning.northstar.accessor.NorthstarLevel;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockUpdater;
import com.lightning.northstar.world.sealer.SealingMode;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level
implements NorthstarLevel {
    @Unique
    private final ProgressiveBlockUpdater northstar$updater = new ProgressiveBlockUpdater(SealingMode.OTHER);

    protected ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, Supplier<ProfilerFiller> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void northstar$tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        ProfilerFiller profiler = this.m_46473_();
        profiler.m_6180_("northstar:process_seal_updates");
        this.northstar$temperature().processUpdates(self);
        this.northstar$oxygen().processUpdates(self);
        this.northstar$updater.processUpdates((Level)self);
        profiler.m_7238_();
    }

    @Override
    public void northstar$queueBlockUpdates(LongCollection positions) {
        this.northstar$updater.queueUpdates(positions);
    }

    @ModifyReturnValue(method={"getSeed"}, at={@At(value="RETURN")})
    private long northstar$modifySeed(long seed) {
        return seed + NorthstarPlanets.getSeedOffset((ResourceKey<Level>)this.m_46472_());
    }
}

