/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CoilerTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CoilerTrunkPlacer> CODEC = RecordCodecBuilder.create(i -> CoilerTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)i).and(i.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(p -> p.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(p -> Float.valueOf(p.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p -> p.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(p -> p.canGrowThrough), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p -> p.spinFactor))).apply((Applicative)i, CoilerTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;
    private final IntProvider spinFactor;

    public CoilerTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough, IntProvider spinFactor) {
        super(baseHeight, heightRandA, heightRandB);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
        this.spinFactor = spinFactor;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70319_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int spinX = 0;
        int spinZ = 0;
        int spinZAdd = -1;
        int spinXAdd = 1;
        boolean spinOrder = false;
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            if (!spinOrder) {
                if ((spinX += spinXAdd) >= 1) {
                    spinXAdd = -1;
                    spinOrder = true;
                }
                if (spinX <= -1) {
                    spinXAdd = 1;
                    spinOrder = true;
                }
            }
            if (spinOrder) {
                if ((spinZ += spinZAdd) >= 1) {
                    spinZAdd = -1;
                    spinOrder = false;
                }
                if (spinZ <= -1) {
                    spinZAdd = 1;
                    spinOrder = false;
                }
            }
            int Xpos = pPos.m_123341_() + spinX;
            int Zpos = pPos.m_123343_() + spinZ;
            int j = pPos.m_123342_() + i;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j - 1, Zpos), pConfig);
            if (i != pFreeTreeHeight - 1) continue;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos + 1, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos - 1, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos + 1), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos - 1), pConfig);
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j + 1, Zpos), 0, false));
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos2 = new BlockPos.MutableBlockPos();
        int spinX2 = 0;
        int spinZ2 = 0;
        int spinZAdd2 = -1;
        int spinXAdd2 = 1;
        boolean spinOrder2 = false;
        for (int i2 = 0; i2 < pFreeTreeHeight; ++i2) {
            if (!spinOrder2) {
                if ((spinX2 += spinXAdd2) >= 2) {
                    spinXAdd2 = -1;
                    spinOrder2 = true;
                }
                if (spinX2 <= -2) {
                    spinXAdd2 = 1;
                    spinOrder2 = true;
                }
            }
            if (spinOrder2) {
                if ((spinZ2 += spinZAdd2) >= 2) {
                    spinZAdd2 = -1;
                    spinOrder2 = false;
                }
                if (spinZ2 <= -2) {
                    spinZAdd2 = 1;
                    spinOrder2 = false;
                }
            }
            int Xpos = pPos.m_123341_() + spinX2;
            int Zpos = pPos.m_123343_() + spinZ2;
            int j = pPos.m_123342_() + i2;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j - 1, Zpos), pConfig);
            if (i2 != pFreeTreeHeight - 1) continue;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos + 1, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos - 1, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j, Zpos + 1), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j, Zpos - 1), pConfig);
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j + 1, Zpos), 0, false));
        }
        return list;
    }

    protected boolean m_226187_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.m_226175_(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean m_226175_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(pConfig.f_68185_.m_213972_(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean m_213554_(LevelSimulatedReader pLevel, BlockPos pPos) {
        return super.m_213554_(pLevel, pPos) || pLevel.m_7433_(pPos, p -> p.m_204341_(this.canGrowThrough));
    }
}

