/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class TestSaplingTrunkPlacer
extends TrunkPlacer {
    public static final Codec<TestSaplingTrunkPlacer> CODEC = RecordCodecBuilder.create(i -> TestSaplingTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)i).and(i.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(p -> p.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(p -> Float.valueOf(p.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p -> p.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(p -> p.canGrowThrough), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p -> p.spinFactor))).apply((Applicative)i, TestSaplingTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;
    private final IntProvider spinFactor;

    public TestSaplingTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough, IntProvider spinFactor) {
        super(baseHeight, heightRandA, heightRandB);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
        this.spinFactor = spinFactor;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70319_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration) {
        ArrayList list = Lists.newArrayList();
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos, treeconfiguration, Direction.UP);
        this.placeBranch(pLevel, pBlockSetter, pRandom, 90 + pRandom.m_216339_(1, 12), pPos.m_121945_(Direction.NORTH), treeconfiguration, pRandom.m_188501_(), Direction.NORTH);
        this.placeBranch(pLevel, pBlockSetter, pRandom, 90 + pRandom.m_216339_(1, 12), pPos.m_121945_(Direction.SOUTH), treeconfiguration, pRandom.m_188501_(), Direction.SOUTH);
        this.placeBranch(pLevel, pBlockSetter, pRandom, 90 + pRandom.m_216339_(1, 12), pPos.m_121945_(Direction.EAST), treeconfiguration, pRandom.m_188501_(), Direction.EAST);
        this.placeBranch(pLevel, pBlockSetter, pRandom, 90 + pRandom.m_216339_(1, 12), pPos.m_121945_(Direction.WEST), treeconfiguration, pRandom.m_188501_(), Direction.WEST);
        this.placeOre(pLevel, pBlockSetter, pRandom, 90 + pRandom.m_216339_(1, 12), pPos, treeconfiguration);
        this.placeCap(pLevel, pBlockSetter, pRandom, 90 + pRandom.m_216339_(1, 12), pPos, treeconfiguration);
        return list;
    }

    public List<FoliagePlacer.FoliageAttachment> placeBranch(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration, float bias, Direction dir) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = pPos.m_122032_();
        int yPos = pPos.m_123342_();
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            if ((double)pRandom.m_188501_() > 0.7 && i != 0) {
                if (pRandom.m_188501_() < bias) {
                    mutable.m_122173_(dir.m_122427_());
                } else {
                    mutable.m_122173_(dir.m_122428_());
                }
            }
            if ((double)pRandom.m_188501_() > 0.9 && i != 0) {
                float newBias = pRandom.m_188501_();
                while (0.49 > (double)Math.abs(bias - newBias)) {
                    newBias = pRandom.m_188501_();
                }
                this.placeSecondBranch(pLevel, pBlockSetter, pRandom, pFreeTreeHeight - 1, (BlockPos)mutable, treeconfiguration, pRandom.m_216339_(1, 4), newBias, dir, pRandom.m_188499_() ? dir.m_122427_() : dir.m_122428_());
            }
            yPos = mutable.m_123342_();
            int Xpos = mutable.m_123341_();
            int Zpos = mutable.m_123343_();
            boolean moveFlag = false;
            if (pLevel.m_7433_(mutable.m_7495_(), block -> block.m_60804_((BlockGetter)pLevel, mutable.m_7495_())) && pLevel.m_7433_((BlockPos)mutable, BlockBehaviour.BlockStateBase::m_247087_)) {
                yPos = mutable.m_123342_();
                moveFlag = true;
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)mutable.m_122178_(Xpos, yPos, Zpos), treeconfiguration, dir);
            } else if (pLevel.m_7433_(mutable.m_7495_(), BlockBehaviour.BlockStateBase::m_247087_)) {
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, Direction.DOWN);
                mutable.m_122173_(Direction.DOWN);
            } else if (pLevel.m_7433_((BlockPos)mutable, block -> block.m_60804_((BlockGetter)pLevel, (BlockPos)mutable)) && pLevel.m_7433_(mutable.m_7494_(), BlockBehaviour.BlockStateBase::m_247087_)) {
                mutable.m_122184_(0, 1, 0);
                moveFlag = true;
                yPos = mutable.m_123342_();
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)mutable.m_122178_(Xpos, yPos, Zpos), treeconfiguration, dir);
            } else if (pLevel.m_7433_(mutable.m_7495_().m_7495_(), block -> block.m_60804_((BlockGetter)pLevel, mutable.m_7495_().m_7495_())) && pLevel.m_7433_(mutable.m_7495_(), BlockBehaviour.BlockStateBase::m_247087_)) {
                mutable.m_122184_(0, -1, 0);
                moveFlag = true;
                yPos = mutable.m_123342_();
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)mutable.m_122178_(Xpos, yPos, Zpos), treeconfiguration, dir);
            } else if (pLevel.m_7433_(mutable.m_121945_(dir), block -> block.m_60804_((BlockGetter)pLevel, mutable.m_121945_(dir))) && pLevel.m_7433_((BlockPos)mutable, BlockBehaviour.BlockStateBase::m_247087_)) {
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, Direction.UP);
                mutable.m_122173_(Direction.UP);
            } else {
                i += 999999999;
            }
            if (!pLevel.m_7433_(mutable.m_121945_(dir).m_7495_(), BlockBehaviour.BlockStateBase::m_247087_) && !pLevel.m_7433_(mutable.m_121945_(dir), BlockBehaviour.BlockStateBase::m_247087_) && !pLevel.m_7433_(mutable.m_121945_(dir).m_7494_(), BlockBehaviour.BlockStateBase::m_247087_) || !moveFlag) continue;
            mutable.m_122173_(dir);
        }
        return list;
    }

    public List<FoliagePlacer.FoliageAttachment> placeSecondBranch(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration, int dist, float bias, Direction dir, Direction offshootDir) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = pPos.m_122032_();
        int yPos = pPos.m_123342_();
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            Direction newDir = dir;
            if ((double)pRandom.m_188501_() > 0.7 && i > 3) {
                if (pRandom.m_188501_() > bias) {
                    mutable.m_122173_(dir.m_122427_());
                } else {
                    mutable.m_122173_(dir.m_122428_());
                }
            }
            yPos = mutable.m_123342_();
            int Xpos = mutable.m_123341_();
            int Zpos = mutable.m_123343_();
            boolean moveFlag = false;
            if (i <= dist) {
                newDir = offshootDir;
            }
            if (pLevel.m_7433_(mutable.m_7495_(), block -> block.m_60804_((BlockGetter)pLevel, mutable.m_7495_())) && pLevel.m_7433_((BlockPos)mutable, BlockBehaviour.BlockStateBase::m_247087_)) {
                yPos = mutable.m_123342_();
                moveFlag = true;
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, newDir);
            } else if (pLevel.m_7433_(mutable.m_7495_(), BlockBehaviour.BlockStateBase::m_247087_)) {
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, Direction.DOWN);
                mutable.m_122173_(Direction.DOWN);
            } else if (pLevel.m_7433_((BlockPos)mutable, block -> block.m_60804_((BlockGetter)pLevel, (BlockPos)mutable)) && pLevel.m_7433_(mutable.m_7494_(), BlockBehaviour.BlockStateBase::m_247087_)) {
                mutable.m_122184_(0, 1, 0);
                moveFlag = true;
                yPos = mutable.m_123342_();
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, newDir);
            } else if (pLevel.m_7433_(mutable.m_7495_().m_7495_(), block -> block.m_60804_((BlockGetter)pLevel, mutable.m_7495_().m_7495_())) && pLevel.m_7433_(mutable.m_7495_(), BlockBehaviour.BlockStateBase::m_247087_)) {
                mutable.m_122184_(0, -1, 0);
                moveFlag = true;
                yPos = mutable.m_123342_();
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, newDir);
            } else if (pLevel.m_7433_(mutable.m_121945_(dir), block -> block.m_60804_((BlockGetter)pLevel, mutable.m_121945_(dir))) && pLevel.m_7433_((BlockPos)mutable, BlockBehaviour.BlockStateBase::m_247087_)) {
                this.placeLog(pLevel, pBlockSetter, pRandom, new BlockPos((Vec3i)mutable.m_122178_(Xpos, yPos, Zpos)), treeconfiguration, Direction.UP);
                mutable.m_122173_(Direction.UP);
            } else {
                i += 999999999;
            }
            if (!pLevel.m_7433_(mutable.m_121945_(dir).m_7495_(), BlockBehaviour.BlockStateBase::m_247087_) && !pLevel.m_7433_(mutable.m_121945_(dir), BlockBehaviour.BlockStateBase::m_247087_) && !pLevel.m_7433_(mutable.m_121945_(dir).m_7494_(), BlockBehaviour.BlockStateBase::m_247087_)) continue;
            if (i <= dist && moveFlag) {
                mutable.m_122173_(offshootDir);
                continue;
            }
            if (!moveFlag) continue;
            mutable.m_122173_(dir);
        }
        return list;
    }

    public void placeOre(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    pBlockSetter.accept(pPos.m_7918_(x, y - 2, z), ((DropExperienceBlock)NorthstarBlocks.MERCURY_DEEP_TUNGSTEN_ORE.get()).m_49966_());
                }
            }
        }
    }

    public void placeCap(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                pBlockSetter.accept(pPos.m_7918_(x, 1, z), Blocks.f_50730_.m_49966_());
            }
        }
        pBlockSetter.accept(pPos.m_7918_(2, 2, -1), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(2, 2, 0), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(2, 2, 1), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(-1, 2, 2), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(0, 2, 2), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(1, 2, 2), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(-2, 2, -1), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(-2, 2, 0), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(-2, 2, 1), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(-1, 2, -2), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(0, 2, -2), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(1, 2, -2), Blocks.f_50730_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(0, 2, 0), Blocks.f_50701_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(0, 3, 0), Blocks.f_50701_.m_49966_());
        pBlockSetter.accept(pPos.m_7918_(0, 4, 0), Blocks.f_50701_.m_49966_());
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration treeconfiguration, Direction dir) {
        return this.placeLog(pLevel, pBlockSetter, pRandom, pPos, treeconfiguration, Function.identity(), dir);
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration treeconfiguration, Function<Object, Object> function, Direction dir) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, (BlockState)function.apply(treeconfiguration.f_68185_.m_213972_(pRandom, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_())));
            return true;
        }
        return false;
    }

    protected boolean placeBlackstone(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration treeconfiguration, Function<Object, Object> function, Direction dir) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, Blocks.f_50730_.m_49966_());
            return true;
        }
        return false;
    }

    protected boolean placeShroomlight(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration treeconfiguration, Function<Object, Object> function, Direction dir) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, Blocks.f_50701_.m_49966_());
            return true;
        }
        return false;
    }

    protected boolean m_213554_(LevelSimulatedReader pLevel, BlockPos pPos) {
        return true;
    }
}

