/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.oxygen;

import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.world.oxygen.OxygenConsumer;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.lightning.northstar.world.sealer.SealingMode;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OxygenTrackingSealer
extends ProgressiveBlockSealer {
    protected final List<Pair<BlockPos, OxygenConsumer>> sealingConsumers = new ArrayList<Pair<BlockPos, OxygenConsumer>>();
    protected final List<Pair<BlockPos, OxygenConsumer>> consumers = new ArrayList<Pair<BlockPos, OxygenConsumer>>();
    protected float baseActiveDrain;
    protected float sealingActiveDrain;
    protected float activeDrain;

    public OxygenTrackingSealer(SealingMode mode) {
        super(mode);
    }

    @Override
    public boolean beginSeal(Level level, BlockPos origin, @Nullable Direction originDirection) {
        this.baseActiveDrain = NorthstarConfigs.server().oxygenSealerBlockActiveDrain.getF();
        return super.beginSeal(level, origin, originDirection);
    }

    @Override
    protected void onSealComplete(int maximumSealed, long lastChecked) {
        super.onSealComplete(maximumSealed, lastChecked);
        this.consumers.clear();
        this.consumers.addAll(this.sealingConsumers);
        this.sealingConsumers.clear();
        this.activeDrain = this.sealingActiveDrain;
        this.sealingActiveDrain = 0.0f;
    }

    @Override
    protected void onBlockAdded(BlockGetter level, BlockPos pos) {
        OxygenConsumer cons;
        OxygenConsumer consumer;
        Block block = level.m_8055_(pos).m_60734_();
        OxygenConsumer oxygenConsumer = consumer = block instanceof OxygenConsumer ? (cons = (OxygenConsumer)block) : (OxygenConsumer)OxygenConsumer.REGISTRY.get((Object)block);
        if (consumer != null && !consumer.northstar$isGogglesOnly(level, pos)) {
            if (consumer.northstar$isOxygenConsumptionDynamic(level, pos)) {
                this.sealingConsumers.add((Pair<BlockPos, OxygenConsumer>)Pair.of((Object)new BlockPos((Vec3i)pos), (Object)consumer));
            } else {
                this.sealingActiveDrain += consumer.northstar$getOxygenConsumption(level, pos, this.baseActiveDrain);
            }
        }
    }

    public float calculateDynamicConsumption(Level level) {
        float sum = 0.0f;
        int j = this.consumers.size();
        for (int i = 0; i < j; ++i) {
            Pair<BlockPos, OxygenConsumer> consumer = this.consumers.get(i);
            sum += ((OxygenConsumer)consumer.right()).northstar$getOxygenConsumption((BlockGetter)level, (BlockPos)consumer.left(), this.baseActiveDrain);
        }
        return sum;
    }

    public float getPassiveDrain() {
        return (float)this.getSealedBlockCount() * NorthstarConfigs.server().oxygenSealerPassiveDrain.getF();
    }

    public float getActiveDrain() {
        return this.activeDrain;
    }
}

