/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.temperature;

import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlockEntity;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockUpdater;
import com.lightning.northstar.world.sealer.SealingMode;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllFluids;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class NorthstarTemperature {
    public static final int MINIMUM_TEMPERATURE = -273;
    public static final int MAXIMUM_TEMPERATURE = 1500;
    private final Level level;
    private final Set<Provider> providers;
    private final ProgressiveBlockUpdater updater;

    public NorthstarTemperature(Level level) {
        this.level = level;
        this.providers = new HashSet<Provider>();
        this.updater = new ProgressiveBlockUpdater(SealingMode.TEMPERATURE);
    }

    public float getTemperatureAt(Vec3 pos) {
        float temperature = 0.0f;
        int count = 0;
        for (Provider provider : this.providers) {
            if (!provider.isSealed(pos)) continue;
            temperature += provider.getTemperature();
            ++count;
        }
        return count == 0 ? NorthstarTemperature.getBaseTemperature(this.level, BlockPos.m_274446_((Position)pos)) : temperature / (float)count;
    }

    public float getTemperatureAt(Vec3i pos) {
        BlockPos bp;
        float temperature = 0.0f;
        int count = 0;
        for (Provider provider : this.providers) {
            if (!provider.isSealed(pos)) continue;
            temperature += provider.getTemperature();
            ++count;
        }
        return count == 0 ? NorthstarTemperature.getBaseTemperature(this.level, pos instanceof BlockPos ? (bp = (BlockPos)pos) : new BlockPos(pos)) : temperature / (float)count;
    }

    public void registerSealer(Provider provider) {
        this.providers.add(provider);
    }

    public void unregisterSealer(Provider provider) {
        this.providers.remove(provider);
    }

    public void enqueueUpdates(LongCollection positions) {
        this.updater.queueUpdates(positions);
    }

    @ApiStatus.Internal
    public void processUpdates(ServerLevel level) {
        this.updater.processUpdates((Level)level);
    }

    public static float getTemperatureAt(Level level, Vec3 pos) {
        return level.northstar$temperature().getTemperatureAt(pos);
    }

    public static float getTemperatureAt(Level level, Vec3i pos) {
        return level.northstar$temperature().getTemperatureAt(pos);
    }

    public static NorthstarTemperature getDimension(Level level) {
        return level.northstar$temperature();
    }

    public static float getBaseTemperature(Level level, BlockPos pos) {
        if (level.m_46472_() == NorthstarDimensions.MERCURY_DIM_KEY) {
            return level.m_45527_(pos) && !level.m_46462_() ? 434.0f : -200.0f;
        }
        return NorthstarPlanets.getPlanetTemp((ResourceKey<Level>)level.m_46472_());
    }

    @ApiStatus.Internal
    public static void tickEntity(LivingEntity entity) {
        Player player;
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        float temp = NorthstarTemperature.getTemperatureAt(entity.m_9236_(), entity.m_146892_());
        boolean hasInsulation = NorthstarTemperature.hasInsulation(entity);
        boolean hasHeatProtection = NorthstarTemperature.hasHeatProtection(entity);
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        if (temp > -32.0f && temp < 300.0f) {
            return;
        }
        if (temp < -32.0f && !hasInsulation && !NorthstarTags.NorthstarEntityTags.CAN_SURVIVE_COLD.matches((Entity)entity)) {
            int ticksFrozen = Math.min(entity.m_146891_(), entity.m_146888_()) + 3;
            entity.m_146917_(ticksFrozen);
            if (ticksFrozen >= entity.m_146891_() / 2) {
                int damage = entity.m_6095_().m_204039_(EntityTypeTags.f_144295_) ? 7 : 2;
                entity.m_6469_(entity.m_9236_().m_269111_().m_269109_(), (float)damage);
            }
        }
        if (temp > 300.0f && !entity.m_6060_() && !entity.m_5825_() && !hasHeatProtection) {
            entity.m_20254_(5);
        }
    }

    public static boolean isCombustible(FluidState state) {
        return state.m_192917_(NorthstarFluids.HYDROCARBON.getSource().m_5613_());
    }

    public static int combustionTemp(FluidState state) {
        if (state.m_192917_(NorthstarFluids.HYDROCARBON.getSource().m_5613_()) || state.m_192917_((Fluid)NorthstarFluids.HYDROCARBON.get())) {
            return 300;
        }
        return 1000;
    }

    public static int getBoilingPoint(FluidState state) {
        if (state.m_192917_((Fluid)Fluids.f_76193_) || state.m_192917_((Fluid)Fluids.f_76192_)) {
            return 100;
        }
        if (state.m_192917_((Fluid)Fluids.f_76195_) || state.m_192917_((Fluid)Fluids.f_76194_)) {
            return 1200;
        }
        if (state.m_192917_((Fluid)AllFluids.CHOCOLATE.get()) || state.m_192917_((Fluid)AllFluids.HONEY.get())) {
            return 70;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.METHANE.get()) || state.m_192917_(NorthstarFluids.METHANE.getSource().m_5613_())) {
            return -80;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.HYDROCARBON.get()) || state.m_192917_(NorthstarFluids.HYDROCARBON.getSource().m_5613_())) {
            return 500;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.LIQUID_OXYGEN.get()) || state.m_192917_(NorthstarFluids.LIQUID_OXYGEN.getSource().m_5613_())) {
            return -180;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.LIQUID_HYDROGEN.get()) || state.m_192917_(NorthstarFluids.LIQUID_HYDROGEN.getSource().m_5613_())) {
            return -253;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.SULFURIC_ACID.get()) || state.m_192917_(NorthstarFluids.SULFURIC_ACID.getSource().m_5613_())) {
            return 1200;
        }
        return 100;
    }

    public static int getFreezingPoint(FluidState state) {
        if (state.m_192917_((Fluid)Fluids.f_76193_) || state.m_192917_((Fluid)Fluids.f_76192_)) {
            return 0;
        }
        if (state.m_192917_((Fluid)Fluids.f_76195_) || state.m_192917_((Fluid)Fluids.f_76194_)) {
            return -200;
        }
        if (state.m_192917_((Fluid)AllFluids.CHOCOLATE.get()) || state.m_192917_((Fluid)AllFluids.HONEY.get())) {
            return 20;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.METHANE.get()) || state.m_192917_(NorthstarFluids.METHANE.getSource().m_5613_())) {
            return -200;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.LIQUID_OXYGEN.get()) || state.m_192917_(NorthstarFluids.LIQUID_OXYGEN.getSource().m_5613_())) {
            return -220;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.HYDROCARBON.get()) || state.m_192917_(NorthstarFluids.HYDROCARBON.getSource().m_5613_())) {
            return -60;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.LIQUID_HYDROGEN.get()) || state.m_192917_(NorthstarFluids.LIQUID_HYDROGEN.getSource().m_5613_())) {
            return -259;
        }
        if (state.m_192917_((Fluid)NorthstarFluids.SULFURIC_ACID.get()) || state.m_192917_(NorthstarFluids.SULFURIC_ACID.getSource().m_5613_())) {
            return -200;
        }
        return 0;
    }

    public static boolean hasInsulation(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_204117_(NorthstarTags.NorthstarItemTags.INSULATING.tag) && entity.m_6844_(EquipmentSlot.CHEST).m_204117_(NorthstarTags.NorthstarItemTags.INSULATING.tag) && entity.m_6844_(EquipmentSlot.LEGS).m_204117_(NorthstarTags.NorthstarItemTags.INSULATING.tag) && entity.m_6844_(EquipmentSlot.FEET).m_204117_(NorthstarTags.NorthstarItemTags.INSULATING.tag) || NorthstarTags.NorthstarEntityTags.CAN_SURVIVE_COLD.matches((Entity)entity);
    }

    public static boolean hasHeatProtection(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_204117_(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) && entity.m_6844_(EquipmentSlot.CHEST).m_204117_(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) && entity.m_6844_(EquipmentSlot.LEGS).m_204117_(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) && entity.m_6844_(EquipmentSlot.FEET).m_204117_(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag);
    }

    public static double getHeatRating(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 0.05;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 5.0;
        }
        if (level == Level.f_46428_) {
            return 0.4;
        }
        return 1.0;
    }

    public static double getHeatConstant(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 50.0;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 1000.0;
        }
        if (level == Level.f_46428_) {
            return 100.0;
        }
        return 1.0;
    }

    public static void evaporate(Level level, BlockPos pos) {
        RandomSource random = level.f_46441_;
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)((float)pos.m_123341_() + random.m_188501_()), (double)((float)pos.m_123342_() + random.m_188501_()), (double)((float)pos.m_123343_() + random.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPostRender(RenderLevelStageEvent event) {
        if (!((Boolean)NorthstarConfigs.client().debugSealerBounds.get()).booleanValue()) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            PoseStack pose = event.getPoseStack();
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            pose.m_85836_();
            pose.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
            for (Provider provider : Minecraft.m_91087_().f_91073_.northstar$temperature().providers) {
                if (!(provider instanceof TemperatureRegulatorBlockEntity)) continue;
                TemperatureRegulatorBlockEntity regulator = (TemperatureRegulatorBlockEntity)provider;
                regulator.getSealer().getVisualizer().render(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
            }
            pose.m_85849_();
        }
    }

    public static interface Provider
    extends SealingProvider {
        public float getTemperature();
    }
}

