/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar;

import com.lightning.northstar.block.tech.rocket_controls.RocketControlsClientHandler;
import com.lightning.northstar.client.renderer.armor.SpaceSuitLayerRenderer;
import com.lightning.northstar.client.renderer.effect.MarsEffects;
import com.lightning.northstar.client.renderer.effect.SpaceEffects;
import com.lightning.northstar.client.renderer.effect.VenusEffects;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.item.armor.RemainingOxygenOverlay;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.ponder.NorthstarPonderPlugin;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.simibubi.create.foundation.utility.LangNumberFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NorthstarClient {
    public static void onCtorClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        modEventBus.addListener(NorthstarParticles::registerFactories);
        NorthstarPonderPlugin.register();
    }

    @SubscribeEvent
    public static void onRegisterDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(NorthstarDimensions.SPACE_EFFECTS, (DimensionSpecialEffects)new SpaceEffects());
        event.register(NorthstarDimensions.MARS_EFFECTS, (DimensionSpecialEffects)new MarsEffects());
        event.register(NorthstarDimensions.VENUS_EFFECTS, (DimensionSpecialEffects)new VenusEffects());
    }

    @SubscribeEvent
    public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        SpaceSuitLayerRenderer.registerOnAll(dispatcher);
    }

    @SubscribeEvent
    public static void registerRenderers(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((ForgeFlowingFluid.Flowing)NorthstarFluids.SULFURIC_ACID.get()).m_5613_(), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.SULFURIC_ACID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((ForgeFlowingFluid.Flowing)NorthstarFluids.LIQUID_HYDROGEN.get()).m_5613_(), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.LIQUID_HYDROGEN.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((ForgeFlowingFluid.Flowing)NorthstarFluids.LIQUID_OXYGEN.get()).m_5613_(), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.LIQUID_OXYGEN.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((ForgeFlowingFluid.Flowing)NorthstarFluids.METHANE.get()).m_5613_(), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.METHANE.get()), (RenderType)RenderType.m_110466_());
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.AIR_LEVEL.id(), "remaining_oxygen", (IGuiOverlay)RemainingOxygenOverlay.INSTANCE);
    }

    @Mod.EventBusSubscriber(modid="northstar", value={Dist.CLIENT})
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(stack)) {
                return;
            }
            MutableComponent tooltip = Component.m_237115_((String)"northstar.gui.tooltip.oxygen").m_130946_(LangNumberFormat.format((double)tag.m_128451_("Oxygen"))).m_7220_((Component)NorthstarLang.MB.component()).m_130940_(ChatFormatting.GRAY);
            event.getToolTip().add(1, tooltip);
        }

        @SubscribeEvent
        public static void onTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                RocketControlsClientHandler.tick();
            }
        }
    }
}

