/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.api.data.recipe;

import com.google.common.base.Supplier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.data.Mod;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;

public abstract class StandardRecipeGen
extends CreateRecipeProvider {
    public void createMaterial(ItemLike nuggets, ItemLike ingot, ItemLike block) {
        if (nuggets != null) {
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> nuggets)).returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).withSuffix("_from_ingot").viaShapeless(b -> b.m_126209_(ingot));
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> nuggets)).withSuffix("_from_nuggets").viaShaped(b -> b.m_126127_(Character.valueOf('#'), nuggets).m_126130_("###").m_126130_("###").m_126130_("###"));
        }
        if (block != null) {
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> block)).withSuffix("_from_block").viaShapeless(b -> b.m_126209_(block));
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> block)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).withSuffix("_from_ingot").viaShaped(b -> b.m_126127_(Character.valueOf('#'), ingot).m_126130_("###").m_126130_("###").m_126130_("###"));
        }
    }

    public void interchangeable(ItemLike item1, ItemLike item2) {
        this.create((Supplier<? extends ItemLike>)((Supplier)() -> item1)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item2)).withSuffix("_from_" + RegisteredObjects.getKeyOrThrow((Item)item2.m_5456_()).m_135815_()).viaShapeless(b -> b.m_126209_(item2));
        this.create((Supplier<? extends ItemLike>)((Supplier)() -> item2)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item1)).withSuffix("_from_" + RegisteredObjects.getKeyOrThrow((Item)item1.m_5456_()).m_135815_()).viaShapeless(b -> b.m_126209_(item1));
    }

    public void createOre(Supplier<TagKey<Item>> ore, Supplier<? extends ItemLike> ingot, float xp, int smeltDuration) {
        this.create(ingot).unlockedByTag(ore).viaCookingTag(ore).rewardXP(xp).forDuration(smeltDuration).inBlastFurnace();
    }

    protected Builder create(Supplier<? extends ItemLike> result) {
        return new Builder(result);
    }

    protected Builder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create((Supplier<? extends ItemLike>)((Supplier)() -> result.get()));
    }

    public StandardRecipeGen(PackOutput output, String defaultNamespace) {
        super(output);
    }

    public class Builder {
        private Supplier<? extends ItemLike> result;
        private int amount;
        private String suffix;
        private List<ICondition> conditions;
        private Supplier<ItemPredicate> unlockedBy;

        public Builder(Supplier<? extends ItemLike> result) {
            this.result = result;
            this.amount = 1;
            this.suffix = "";
            this.conditions = new ArrayList<ICondition>();
            this.unlockedBy = null;
        }

        public Builder returns(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        public Builder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        public Builder whenModLoaded(Mod mod) {
            return this.whenModLoaded(mod.getModId());
        }

        public Builder whenModLoaded(String modId) {
            return this.withCondition((ICondition)new ModLoadedCondition(modId));
        }

        public Builder whenModMissing(Mod mod) {
            return this.whenModMissing(mod.getModId());
        }

        public Builder whenModMissing(String modId) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modId)));
        }

        public Builder withCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public CreateRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return StandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)StandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        public CreateRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return StandardRecipeGen.this.register(recipeOutput -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)StandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(result -> recipeOutput.accept(!this.conditions.isEmpty() ? new ConditionSupportingShapelessRecipeResult((FinishedRecipe)result, this.conditions) : result), this.createLocation("crafting"));
            });
        }

        public Cooking viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        public Cooking viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get()))));
        }

        public Cooking viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new Cooking(ingredient);
        }

        private ResourceLocation createLocation(String recipeType) {
            return Northstar.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return RegisteredObjects.getKeyOrThrow((Item)((ItemLike)this.result.get()).m_5456_());
        }

        public class Cooking {
            private Supplier<Ingredient> ingredient;
            private int duration;
            private float xp;

            private Cooking(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.duration = 200;
                this.xp = 0.0f;
            }

            public Cooking forDuration(int duration) {
                this.duration = duration;
                return this;
            }

            public Cooking rewardXP(float xp) {
                this.xp = xp;
                return this;
            }

            public CreateRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            public CreateRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create((RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, builder, 1.0f);
            }

            public CreateRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            public CreateRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create((RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, builder, 1.0f);
                this.create((RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44094_, builder, 3.0f);
                return this.create((RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44093_, builder, 0.5f);
            }

            public CreateRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            public CreateRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create((RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, builder, 1.0f);
                return this.create((RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, builder, 0.5f);
            }

            private CreateRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return StandardRecipeGen.this.register(consumer -> {
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Builder.this.result.get()), (float)this.xp, (int)((int)((float)this.duration * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (Builder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)StandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)Builder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(consumer, Builder.this.createLocation(RegisteredObjects.getKeyOrThrow((RecipeSerializer)serializer).m_135815_()));
                });
            }
        }
    }

    private record ConditionSupportingShapelessRecipeResult(FinishedRecipe wrapped, List<ICondition> conditions) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(@NotNull JsonObject pJson) {
            this.wrapped.m_7917_(pJson);
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            pJson.add("conditions", (JsonElement)conds);
        }
    }
}

