/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ClusterBlock
extends AmethystBlock
implements ProperWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public ClusterBlock(int size, int offset, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.upAabb = Block.m_49796_((double)offset, (double)0.0, (double)offset, (double)(16 - offset), (double)size, (double)(16 - offset));
        this.downAabb = Block.m_49796_((double)offset, (double)(16 - size), (double)offset, (double)(16 - offset), (double)16.0, (double)(16 - offset));
        this.northAabb = Block.m_49796_((double)offset, (double)offset, (double)(16 - size), (double)(16 - offset), (double)(16 - offset), (double)16.0);
        this.southAabb = Block.m_49796_((double)offset, (double)offset, (double)0.0, (double)(16 - offset), (double)(16 - offset), (double)size);
        this.eastAabb = Block.m_49796_((double)0.0, (double)offset, (double)offset, (double)size, (double)(16 - offset), (double)(16 - offset));
        this.westAabb = Block.m_49796_((double)(16 - size), (double)offset, (double)offset, (double)16.0, (double)(16 - offset), (double)(16 - offset));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING, WATERLOGGED}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            default -> this.upAabb;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.withWater(this.m_49966_(), context).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

