/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.astronomy_table;

import com.lightning.northstar.block.tech.astronomy_table.AstronomyTableBlockEntity;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarMenuTypes;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AstronomyTableMenu
extends MenuBase<AstronomyTableBlockEntity> {
    public Component errorMessage;
    protected SimpleContainer inputSlots;
    protected ResultContainer resultSlots;

    public AstronomyTableMenu(MenuType<AstronomyTableMenu> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public AstronomyTableMenu(MenuType<?> type, int id, Inventory inv, AstronomyTableBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static AstronomyTableMenu create(int id, Inventory inv, AstronomyTableBlockEntity be) {
        return new AstronomyTableMenu((MenuType)NorthstarMenuTypes.ASTRONOMY_TABLE_MENU.get(), id, inv, be);
    }

    protected AstronomyTableBlockEntity createOnClient(FriendlyByteBuf extraData) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(extraData.m_130135_());
        if (blockEntity instanceof AstronomyTableBlockEntity) {
            AstronomyTableBlockEntity be = (AstronomyTableBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    protected void initAndReadInventory(AstronomyTableBlockEntity contentHolder) {
        this.inputSlots = new SimpleContainer(3);
        this.resultSlots = new ResultContainer();
        this.inputSlots.m_19164_(container -> this.updateResult());
    }

    protected void addSlots() {
        class InputSlot
        extends Slot {
            public InputSlot(Container container, int slot, int x, int y) {
                super(container, slot, x, y);
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)NorthstarItems.ASTRONOMICAL_READING.get());
            }
        }
        this.m_38897_(new InputSlot((Container)this.inputSlots, 0, 24, 47));
        this.m_38897_(new InputSlot((Container)this.inputSlots, 1, 80, 47));
        this.m_38897_(new InputSlot((Container)this.inputSlots, 2, 52, 27));
        this.m_38897_(new Slot((Container)this.resultSlots, 3, 134, 47){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                for (int i = 0; i < 3; ++i) {
                    AstronomyTableMenu.this.inputSlots.m_8020_(i).m_41764_(AstronomyTableMenu.this.inputSlots.m_8020_(i).m_41613_() - 1);
                }
                player.m_9236_().m_5594_(player, ((AstronomyTableBlockEntity)((Object)AstronomyTableMenu.this.contentHolder)).m_58899_(), SoundEvents.f_12493_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
        this.addPlayerSlots(8, 84);
    }

    protected void saveData(AstronomyTableBlockEntity contentHolder) {
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, (Container)this.inputSlots);
        this.resultSlots.m_6211_();
    }

    public void updateResult() {
        this.errorMessage = null;
        this.resultSlots.m_6211_();
        ItemStack item1 = this.inputSlots.m_8020_(0);
        ItemStack item2 = this.inputSlots.m_8020_(1);
        ItemStack item3 = this.inputSlots.m_8020_(2);
        CompoundTag compound1 = item1.m_41737_("Planet");
        CompoundTag compound2 = item2.m_41737_("Planet");
        CompoundTag compound3 = item3.m_41737_("Planet");
        if (!(compound1 != null && compound2 != null && compound3 != null && compound1.m_128425_("name", 8) && compound2.m_128425_("name", 8) && compound3.m_128425_("name", 8))) {
            return;
        }
        String planet1 = compound1.m_128461_("name");
        String planet2 = compound2.m_128461_("name");
        String planet3 = compound3.m_128461_("name");
        if (!planet1.equals(planet2) || !planet1.equals(planet3)) {
            this.errorMessage = Component.m_237115_((String)"northstar.gui.astronomy_table.different_planets");
            return;
        }
        if (!this.arePlanetsFarEnough(item1, item2, item3)) {
            this.errorMessage = Component.m_237115_((String)"northstar.gui.astronomy_table.close_data");
            return;
        }
        ItemStack result = new ItemStack((ItemLike)NorthstarItems.STAR_MAP.get());
        result.m_41714_((Component)Component.m_237115_((String)("item.northstar.star_map_" + planet1)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(false))));
        CompoundTag tag = result.m_41698_("Planet");
        tag.m_128359_("name", planet1);
        this.resultSlots.m_6836_(0, result);
    }

    private boolean arePlanetsFarEnough(ItemStack item1, ItemStack item2, ItemStack item3) {
        double r3;
        double r2;
        int x1 = item1.m_41737_("planetX").m_128451_("value");
        int y1 = item1.m_41737_("planetY").m_128451_("value");
        int x2 = item2.m_41737_("planetX").m_128451_("value");
        int y2 = item2.m_41737_("planetY").m_128451_("value");
        int x3 = item3.m_41737_("planetX").m_128451_("value");
        int y3 = item3.m_41737_("planetY").m_128451_("value");
        double r1 = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        double averageDistance = (r1 + (r2 = Math.sqrt(Math.pow(x3 - x2, 2.0) + Math.pow(y3 - y2, 2.0))) + (r3 = Math.sqrt(Math.pow(x1 - x3, 2.0) + Math.pow(y1 - y3, 2.0)))) / 3.0;
        return Math.abs(averageDistance) > 30.0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 3) {
                if (!this.m_38903_(itemstack1, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index != 0 && index != 1 && index != 2) {
                if (index >= 4 && index < 40) {
                    int i = -1;
                    if (((Slot)this.f_38839_.get(0)).m_7993_() == ItemStack.f_41583_ && i == -1) {
                        i = 0;
                    }
                    if (((Slot)this.f_38839_.get(2)).m_7993_() == ItemStack.f_41583_ && i == -1) {
                        i = 2;
                    }
                    if (((Slot)this.f_38839_.get(1)).m_7993_() == ItemStack.f_41583_ && i == -1) {
                        i = 1;
                    }
                    if (i != -1 && !this.m_38903_(itemstack1, i, 3, false)) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.m_38903_(itemstack1, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

