/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.atmospheric_concentrator;

import com.lightning.northstar.block.tech.atmospheric_concentrator.AtmosphericConcentratorBlock;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AtmosphericConcentratorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    protected SmartFluidTankBehaviour tank;
    protected float buffer;

    public AtmosphericConcentratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tick() {
        super.tick();
        Fluid fluid = this.getCollectedFluid();
        float speed = this.getCollectionSpeed();
        if (fluid == Fluids.f_76191_ || Mth.m_14033_((float)speed, (float)0.0f)) {
            return;
        }
        float newBuffer = this.buffer + speed;
        int filled = Mth.m_14143_((float)newBuffer);
        this.buffer = newBuffer - (float)filled;
        this.tank.getPrimaryHandler().fill(new FluidStack(fluid, filled), IFluidHandler.FluidAction.EXECUTE);
    }

    public Fluid getCollectedFluid() {
        ResourceKey dimension = this.f_58857_.m_46472_();
        if (dimension.equals((Object)Level.f_46428_)) {
            return NorthstarFluids.OXYGEN.getSource();
        }
        if (dimension.equals(NorthstarDimensions.MARS_DIM_KEY) || dimension.equals(NorthstarDimensions.VENUS_DIM_KEY)) {
            return NorthstarFluids.CARBON.getSource();
        }
        return Fluids.f_76191_;
    }

    public float getCollectionSpeed() {
        return Math.abs(this.speed) / 25.6f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Fluid fluid;
        NorthstarLang.translate("gui.goggles.atmospheric_concentrator", new Object[0]).forGoggles(tooltip);
        if (IRotate.StressImpact.isEnabled()) {
            this.addStressImpactStats(tooltip, this.calculateStressApplied());
        }
        if ((fluid = this.getCollectedFluid()) == Fluids.f_76191_) {
            NorthstarLang.translate("gui.goggles.atmospheric_concentrator.no_atmosphere", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        } else {
            NorthstarLang.translate("gui.goggles.atmospheric_concentrator.collected_fluid", new Object[0]).style(ChatFormatting.GRAY).add(Lang.fluidName((FluidStack)new FluidStack(fluid, 1))).forGoggles(tooltip);
            Lang.builder().add(Lang.number((double)this.tank.getPrimaryHandler().getFluidAmount()).add(NorthstarLang.MB).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)this.tank.getPrimaryHandler().getCapacity()).add(NorthstarLang.MB).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            NorthstarLang.translate("gui.goggles.atmospheric_concentrator.collection_rate", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.number((double)this.getCollectionSpeed()).add(NorthstarLang.MB_PER_TICK).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == null || side == ((Direction)this.m_58900_().m_61143_(AtmosphericConcentratorBlock.HORIZONTAL_FACING)).m_122424_())) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

