/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.electrolysis_machine;

import com.lightning.northstar.block.tech.electrolysis_machine.ElectrolysisMachineBlock;
import com.lightning.northstar.block.tech.electrolysis_machine.ElectrolysisRecipe;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ElectrolysisMachineBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT1 = new BehaviourType("Output1");
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT2 = new BehaviourType("Output2");
    private static final Object ELECTROLYSIS_RECIPE_KEY = new Object();
    protected SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTankL;
    protected SmartFluidTankBehaviour outputTankR;
    protected float processingTime;
    protected Recipe<?> currentRecipe;

    public ElectrolysisMachineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true);
        this.outputTankL = new SmartFluidTankBehaviour(OUTPUT1, (SmartBlockEntity)this, 1, 1000, true).forbidInsertion();
        this.outputTankR = new SmartFluidTankBehaviour(OUTPUT2, (SmartBlockEntity)this, 1, 1000, true).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTankL);
        behaviours.add((BlockEntityBehaviour)this.outputTankR);
    }

    public void tick() {
        super.tick();
        if (!ElectrolysisRecipe.match(this, this.currentRecipe)) {
            this.currentRecipe = RecipeFinder.get((Object)ELECTROLYSIS_RECIPE_KEY, (Level)this.f_58857_, this::matchStaticFilters).stream().filter(r -> ElectrolysisRecipe.match(this, r)).findFirst().orElse(null);
        }
        if (this.currentRecipe == null) {
            return;
        }
        this.processingTime += Math.abs(this.speed);
        int toProcess = (int)(this.processingTime / 256.0f);
        this.processingTime %= 256.0f;
        for (int i = 0; i < toProcess && ElectrolysisRecipe.apply(this, this.currentRecipe, false); ++i) {
        }
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == NorthstarRecipeTypes.ELECTROLYSIS.getType();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("ProcessingTime", this.processingTime);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.processingTime = compound.m_128457_("ProcessingTime");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            tooltip.add((Component)Component.m_237119_());
        }
        Lang.translate((String)"gui.goggles.electrolysis_machine", (Object[])new Object[0]).forGoggles(tooltip);
        this.addTankToolTip(tooltip, "gui.goggles.electrolysis_input", this.inputTank);
        this.addTankToolTip(tooltip, "gui.goggles.electrolysis_orange_port", this.outputTankL);
        this.addTankToolTip(tooltip, "gui.goggles.electrolysis_blue_port", this.outputTankR);
        return true;
    }

    private void addTankToolTip(List<Component> tooltip, String color, SmartFluidTankBehaviour tank) {
        FluidStack fluidStack = tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.getFluid().getFluidType().isAir()) {
            Lang.translate((String)color, (Object[])new Object[0]).add(Lang.fluidName((FluidStack)fluidStack)).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            Lang.translate((String)color, (Object[])new Object[0]).add(Lang.translate((String)"gui.goggles.empty", (Object[])new Object[0])).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        Lang.builder((String)"northstar").add(Lang.number((double)fluidStack.getAmount()).add(Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getPrimaryHandler().getTankCapacity(0)).add(Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.isFluidHandlerCap(cap) && side == Direction.UP) {
            return this.inputTank.getCapability().cast();
        }
        if (this.isFluidHandlerCap(cap) && side == ((Direction)this.m_58900_().m_61143_(ElectrolysisMachineBlock.HORIZONTAL_FACING)).m_122427_()) {
            return this.outputTankL.getCapability().cast();
        }
        if (this.isFluidHandlerCap(cap) && side == ((Direction)this.m_58900_().m_61143_(ElectrolysisMachineBlock.HORIZONTAL_FACING)).m_122428_()) {
            return this.outputTankR.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

