/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public abstract class FreezingRecipeGen
extends CreateRecipeProvider {
    public FreezingRecipeGen(PackOutput generator, String defaultNamespace) {
        super(generator);
    }

    protected CreateRecipeProvider.GeneratedRecipe createGas(String name, int temperature, TagKey<Fluid> fluidTag, Supplier<? extends Fluid> fluid, TagKey<Fluid> gasTag, Supplier<? extends Fluid> gas) {
        this.create(name + "_condensation", b -> b.colderThan(temperature).duration(20).require(gasTag, 100).output((Fluid)fluid.get(), 100));
        return this.create(name + "_evaporation", b -> b.hotterThan(temperature).duration(20).require(fluidTag, 100).output((Fluid)gas.get(), 100));
    }

    protected CreateRecipeProvider.GeneratedRecipe create(String name, Consumer<FreezingRecipeBuilder> transform) {
        FreezingRecipeBuilder builder = new FreezingRecipeBuilder((ProcessingRecipeBuilder.ProcessingRecipeFactory<FreezingRecipe>)((ProcessingRecipeBuilder.ProcessingRecipeFactory)FreezingRecipe::new), Northstar.asResource(name));
        transform.accept(builder);
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = arg_0 -> ((FreezingRecipeBuilder)builder).build(arg_0);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public String m_6055_() {
        return "Northstar's freezing recipes";
    }

    public static class FreezingRecipeBuilder
    extends ProcessingRecipeBuilder<FreezingRecipe> {
        private FreezingRecipe.Params params;

        public FreezingRecipeBuilder(ProcessingRecipeBuilder.ProcessingRecipeFactory<FreezingRecipe> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
            this.params = new FreezingRecipe.Params(recipeId);
            ((ProcessingRecipeBuilder)this).params = this.params;
        }

        public FreezingRecipeBuilder colderThan(int temp) {
            return this.withinTemperature(Integer.MIN_VALUE, temp);
        }

        public FreezingRecipeBuilder hotterThan(int temp) {
            return this.withinTemperature(temp, Integer.MAX_VALUE);
        }

        public FreezingRecipeBuilder withTemperature(int temp) {
            return this.withinTemperature(temp, temp);
        }

        public FreezingRecipeBuilder withinTemperature(int min, int max) {
            this.params.minTemperature = min;
            this.params.maxTemperature = max;
            return this;
        }
    }
}

