/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.large_fan;

import com.lightning.northstar.block.tech.large_fan.LargeFanBlockEntity;
import com.lightning.northstar.block.tech.large_fan.TenPatch;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.world.sealer.SealableBlock;
import com.lightning.northstar.world.sealer.SealerExtensionSource;
import com.lightning.northstar.world.sealer.SealingMode;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LargeFanBlock
extends KineticBlock
implements IBE<LargeFanBlockEntity>,
IWrenchable,
SealerExtensionSource,
SealableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<TenPatch> PATCH = TenPatch.PROPERTY;

    public LargeFanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Z)).m_61124_(PATCH, (Comparable)((Object)TenPatch.SINGLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AXIS, PATCH}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)(state == null ? this.m_49966_() : state).m_61124_(AXIS, (Comparable)context.m_7820_().m_122434_());
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        LargeFanBlockEntity be = (LargeFanBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null && !be.isController()) {
            be = be.getControllerBE();
        }
        if (be == null) {
            return InteractionResult.PASS;
        }
        if (!heldItem.m_41619_() && heldItem.m_41720_() == NorthstarItems.FAN_BLADE.m_5456_() && hit.m_82434_().m_122434_() == state.m_61143_(AXIS)) {
            if (be.blades < 8) {
                ++be.blades;
                be.sendData();
                if (!player.m_7500_()) {
                    heldItem.m_41764_(heldItem.m_41613_() - 1);
                }
                player.m_21008_(hand, heldItem);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (isMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, LargeFanBlockEntity::updateConnectivity);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_()) && newState.m_155947_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LargeFanBlockEntity) {
            LargeFanBlockEntity be = (LargeFanBlockEntity)blockEntity;
            be.destroy();
            level.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)be);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        Direction modifiedDirection = Direction.m_122378_((int)(neighbor.m_123341_() - pos.m_123341_()), (int)(neighbor.m_123342_() - pos.m_123342_()), (int)(neighbor.m_123343_() - pos.m_123343_()));
        if (modifiedDirection == null || modifiedDirection.m_122434_() == state.m_61143_(AXIS)) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            LargeFanBlockEntity controller = be.getControllerBE();
            if (controller == null) {
                return;
            }
            controller.onNeighborChange(neighbor, false);
        });
    }

    @Override
    public int getMaximumSealedBlocks(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LargeFanBlockEntity) {
            LargeFanBlockEntity be = (LargeFanBlockEntity)blockEntity;
            return be.isController() ? be.getExtraSealedVolume() : 0;
        }
        return 0;
    }

    @Override
    public boolean northstar$isFaceSealed(BlockGetter level, BlockPos pos, BlockState state, Direction direction, boolean source, SealingMode mode) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == direction.m_122434_()) {
            return false;
        }
        TenPatch patch = (TenPatch)((Object)state.m_61143_(PATCH));
        return switch (patch.type) {
            case TenPatch.PatchType.CENTER -> false;
            case TenPatch.PatchType.SIDE -> {
                if (direction == patch.getDirection(axis)) {
                    yield true;
                }
                yield false;
            }
            case TenPatch.PatchType.CORNER -> {
                Direction dir = patch.getDirection(axis);
                if (direction != dir && direction != dir.m_175364_(axis)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.m_43725_(), context.m_8083_(), be -> {
            if (!be.isController()) {
                be = be.getControllerBE();
            }
            if (be == null) {
                return InteractionResult.PASS;
            }
            be.flipChain = !be.flipChain;
            be.sendData();
            return InteractionResult.SUCCESS;
        });
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        return this.onBlockEntityUse((BlockGetter)context.m_43725_(), context.m_8083_(), be -> {
            if (!be.isController()) {
                be = be.getControllerBE();
            }
            if (be == null || be.blades == 0) {
                return super.onSneakWrenched(state, context);
            }
            super.playRemoveSound(world, pos);
            --be.blades;
            be.sendData();
            if (player == null) {
                LargeFanBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)NorthstarItems.FAN_BLADE.asStack());
            } else {
                player.m_150109_().m_150079_(NorthstarItems.FAN_BLADE.asStack());
            }
            return InteractionResult.SUCCESS;
        });
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_(AXIS);
    }

    public Class<LargeFanBlockEntity> getBlockEntityClass() {
        return LargeFanBlockEntity.class;
    }

    public BlockEntityType<? extends LargeFanBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.LARGE_FAN.get();
    }
}

