/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.large_fan;

import com.jozufozu.flywheel.core.PartialModel;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.large_fan.LargeFanBlock;
import com.lightning.northstar.block.tech.large_fan.LargeFanBlockEntity;
import com.lightning.northstar.block.tech.large_fan.TenPatch;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.Arrays;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class LargeFanRenderer
extends SafeBlockEntityRenderer<LargeFanBlockEntity> {
    private static final ResourceLocation CHAIN_LOCATION = Northstar.asResource("textures/block/chain.png");
    private static final Vector3f[] CHAIN_STEP = (Vector3f[])Arrays.stream(Direction.values()).map(Direction::m_253071_).map(v -> v.mul(0.375f)).toArray(Vector3f[]::new);
    private final Vector3f offset = new Vector3f();
    private final Vector3f scale = new Vector3f();
    private final Vector3f chainA = new Vector3f();
    private final Vector3f chainB = new Vector3f();
    private final Vector3f side = new Vector3f();

    public LargeFanRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(LargeFanBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.m_58900_();
        Direction.Axis axis = (Direction.Axis)state.m_61143_(LargeFanBlock.AXIS);
        Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        TenPatch patch = (TenPatch)((Object)state.m_61143_(LargeFanBlock.PATCH));
        PartialModel model = switch (patch.type) {
            default -> throw new IncompatibleClassChangeError();
            case TenPatch.PatchType.SINGLE -> NorthstarPartialModels.LARGE_FAN_SINGLE;
            case TenPatch.PatchType.CENTER -> NorthstarPartialModels.LARGE_FAN_CENTER;
            case TenPatch.PatchType.CORNER -> NorthstarPartialModels.LARGE_FAN_CORNER;
            case TenPatch.PatchType.SIDE -> NorthstarPartialModels.LARGE_FAN_SIDE;
        };
        CachedBufferer.partialFacing((PartialModel)model, (BlockState)state, (Direction)dir).rotateCentered(dir, (float)patch.rotation).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        if (!be.isController()) {
            return;
        }
        Vector3f offset = this.offset.set((float)be.getVolumeX(), (float)be.getVolumeY(), (float)be.getVolumeZ()).mul(0.5f);
        float rot = be.angle + be.effectiveSpeed.getValue() / 1200.0f * partialTicks;
        float angle = rot * ((float)Math.PI * 2);
        int blades = be.blades;
        float size = be.width == 1 ? 0.375f : ((float)be.width - 0.5f) * 0.5f;
        Vector3f scale = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.scale.set(0.999f, size, size);
            case Direction.Axis.Y -> this.scale.set(size, 0.999f, size);
            case Direction.Axis.Z -> this.scale.set(size, size, 0.999f);
        };
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.block((BlockState)((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis))).translate(offset)).scale(scale.x, scale.y, scale.z).rotate(dir, angle * 57.295776f)).unCentre()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partialFacing((PartialModel)NorthstarPartialModels.LARGE_FAN_ROTOR, (BlockState)state, (Direction)dir).translate(offset)).scale(size)).rotate(dir, angle * 57.295776f)).unCentre()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        for (int i = 0; i < blades; ++i) {
            float a = angle + (float)Math.PI * 2 * (float)i / (float)blades;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)NorthstarPartialModels.LARGE_FAN_BLADE, (BlockState)state).translate(offset)).scale(size)).rotate(dir, a * 57.295776f)).rotateY((double)AngleHelper.horizontalAngle((Direction)dir))).rotateX((double)AngleHelper.verticalAngle((Direction)dir))).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        }
    }
}

