/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_filler;

import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlock;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OxygenFillerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public final Container container = new SimpleContainer(1);
    public final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            ItemStack item = OxygenFillerBlockEntity.this.getContainedItem();
            if (tank == 0 || item == null || item.m_41783_() == null) {
                return FluidStack.EMPTY;
            }
            int oxygen = item.m_41783_().m_128451_("Oxygen");
            return oxygen == 0 ? FluidStack.EMPTY : new FluidStack((Fluid)NorthstarFluids.OXYGEN.getSource(), oxygen);
        }

        public int getTankCapacity(int tank) {
            return OxygenFillerBlockEntity.this.getContainedItem() == null ? 0 : 1800;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0 && NorthstarOxygen.isOxygen(stack.getFluid());
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            ItemStack item = OxygenFillerBlockEntity.this.getContainedItem();
            if (!this.isFluidValid(0, stack) || item == null) {
                return 0;
            }
            CompoundTag tag = item.m_41784_();
            int oxygen = tag.m_128451_("Oxygen");
            int fillable = Mth.m_14045_((int)(1800 - oxygen), (int)0, (int)stack.getAmount());
            if (action.execute() && fillable != 0) {
                tag.m_128405_("Oxygen", oxygen + fillable);
                OxygenFillerBlockEntity.this.sendData();
                if (oxygen + fillable >= 1800) {
                    AllSoundEvents.CONFIRM.playOnServer(OxygenFillerBlockEntity.this.f_58857_, (Vec3i)OxygenFillerBlockEntity.this.f_58858_, 0.4f, 0.0f);
                }
            }
            return fillable;
        }

        public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, stack)) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = stack.copy();
            drained.setAmount(this.drainAmount(stack.getAmount(), action));
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)NorthstarFluids.OXYGEN.getSource(), this.drainAmount(maxDrain, action));
        }

        private int drainAmount(int amount, IFluidHandler.FluidAction action) {
            ItemStack item = OxygenFillerBlockEntity.this.getContainedItem();
            if (item == null) {
                return 0;
            }
            CompoundTag tag = item.m_41784_();
            int drainable = Math.min(amount, tag.m_128451_("Oxygen"));
            if (action.execute() && drainable != 0) {
                tag.m_128405_("Oxygen", tag.m_128451_("Oxygen") - drainable);
                OxygenFillerBlockEntity.this.sendData();
            }
            return drainable;
        }
    };

    public OxygenFillerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)new InvWrapper(this.container));
        this.container.m_6211_();
    }

    @Nullable
    protected ItemStack getContainedItem() {
        ItemStack item = this.container.m_8020_(0);
        return NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(item) ? item : null;
    }

    public void tick() {
        super.tick();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("item", (Tag)this.container.m_8020_(0).m_41739_(new CompoundTag()));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.container.m_6836_(0, ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ItemStack item = this.container.m_8020_(0);
        if (item.m_41619_()) {
            return false;
        }
        NorthstarLang.translate("gui.goggles.oxygen_filler", new Object[0]).forGoggles(tooltip);
        Lang.itemName((ItemStack)item).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(item)) {
            CompoundTag tag = item.m_41783_();
            Lang.builder().add(Lang.number((double)(tag != null ? (double)tag.m_128451_("Oxygen") : 0.0)).add(NorthstarLang.MB).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)1800.0).add(NorthstarLang.MB).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        } else {
            Lang.text((String)"Cannot hold oxygen").style(ChatFormatting.RED).forGoggles(tooltip, 1);
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == null || side == ((Direction)this.m_58900_().m_61143_(OxygenFillerBlock.HORIZONTAL_FACING)).m_122424_())) {
            return LazyOptional.of(() -> this.fluidHandler).cast();
        }
        return super.getCapability(cap, side);
    }
}

