/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_station;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlock;
import com.lightning.northstar.block.tech.rocket_station.RocketStationMenu;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.contraption.rocket.RocketContraption;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.lightning.northstar.world.sealer.SealingMode;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.WorldAttached;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class RocketStationBlockEntity
extends SmartBlockEntity
implements IDisplayAssemblyExceptions,
IControlContraption,
MenuProvider {
    boolean assembleNextTick;
    public Player owner;
    protected AssemblyException lastException;
    public TrackTargetingBehaviour<GlobalStation> edgePoint;
    protected ItemStackHandler inventory;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    public String name = "Bing Bong's Big Bonanza";
    protected int failedCarriageIndex;
    Direction assemblyDirection;
    int assemblyLength;
    public float offset;
    public int fuelCost;
    public int fuelReturnCost;
    public boolean running;
    public boolean needsContraption;
    public AbstractContraptionEntity movedContraption;
    protected boolean forceMove;
    protected ScrollOptionBehaviour<IControlContraption.MovementMode> movementMode;
    protected boolean waitingForSpeedChange;
    protected double sequencedOffsetLimit;
    int i = 0;
    protected float clientOffsetDiff;
    public ResourceKey<Level> target;
    public final Container container = new SimpleContainer(1);
    public static WorldAttached<Map<BlockPos, BoundingBox>> assemblyAreas = new WorldAttached(w -> new HashMap());

    public RocketStationBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.inventory = new ItemStackHandler();
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory}));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.CONTRAPTION_ACTORS});
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
    }

    public void queueAssembly(Player player) {
        this.owner = player;
        this.assembleNextTick = true;
    }

    public void enterAssembly() {
        this.assembleNextTick = true;
    }

    public void exitAssembly() {
        this.assembleNextTick = false;
    }

    public void tick() {
        super.tick();
        ++this.i;
        ItemStack item = this.container.m_8020_(0);
        if ((item.m_41720_() == NorthstarItems.STAR_MAP.get() || item.m_41720_() == NorthstarItems.RETURN_TICKET.get()) && item.m_41737_("Planet") != null) {
            this.target = NorthstarPlanets.getPlanetDimension(item.m_41737_("Planet").m_128461_("name"));
        }
        this.fuelCost = this.fuelCalc();
        this.fuelReturnCost = this.fuelReturnCalc();
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    private void tryAssemble() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof RocketStationBlock)) {
            return;
        }
        RocketContraption contraption = new RocketContraption();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_);
        if (!(blockEntity instanceof RocketStationBlockEntity)) {
            return;
        }
        Direction movementDirection = Direction.UP;
        int engines = 0;
        boolean hasStation = false;
        float fuelAmount = 0.0f;
        int requiredJets = 0;
        int heatShielding = 0;
        double heatCost = 0.0;
        double heatCostHome = 0.0;
        try {
            this.lastException = null;
            contraption.owner = this.owner;
            if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
                return;
            }
            engines = contraption.hasJetEngine();
            fuelAmount = contraption.fuelAmount();
            heatShielding = contraption.heatShielding();
            hasStation |= contraption.hasRocketStation();
            contraption.fuelCost = this.fuelCost;
            contraption.fuelReturnCost = this.fuelReturnCost;
            contraption.dest = this.target;
            heatCost = NorthstarTemperature.getHeatRating(this.target) * (double)contraption.blockCount + NorthstarTemperature.getHeatConstant(this.target);
            heatCostHome = NorthstarTemperature.getHeatRating((ResourceKey<Level>)this.f_58857_.m_46472_()) * (double)contraption.blockCount + NorthstarTemperature.getHeatConstant((ResourceKey<Level>)this.f_58857_.m_46472_());
            if (heatCostHome > heatCost) {
                heatCost = heatCostHome;
            }
            requiredJets = this.engineCalc();
            this.sendData();
        }
        catch (AssemblyException e) {
            this.owner.m_5661_((Component)Component.m_237115_((String)"northstar.gui.rocket_too_big").m_130940_(ChatFormatting.RED), false);
            this.owner.m_5661_((Component)Component.m_237115_((String)"northstar.gui.current_config_size").m_130940_(ChatFormatting.RED), false);
            this.owner.m_5661_((Component)Component.m_237113_((String)((Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()).toString()).m_130940_(ChatFormatting.RED), false);
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld((Level)this.f_58857_, (TranslatingContraption)contraption, (BlockPos)this.f_58858_.m_121945_(movementDirection), (Direction)movementDirection)) {
            if (!this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60795_()) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Rocket Stations require at least 1 block of space above them").m_130940_(ChatFormatting.RED), false);
            } else {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Something's blocking your rocket! Make sure everything is glued together!").m_130940_(ChatFormatting.RED), false);
            }
            return;
        }
        Northstar.LOGGER.debug("Obamna");
        ProgressiveBlockSealer sealer = new ProgressiveBlockSealer(SealingMode.OXYGEN);
        ContraptionWorld contraptionWorld = new ContraptionWorld(this.f_58857_, (Contraption)contraption);
        int maximumSealedBlocks = (Integer)NorthstarConfigs.server().oxygenSealerMaxContraptionSealed.get();
        boolean oxygenSealed = sealer.beginSeal((Level)contraptionWorld, BlockPos.f_121853_, Direction.UP) && sealer.updateSeal((Level)contraptionWorld, maximumSealedBlocks, maximumSealedBlocks) && !sealer.hasLeak();
        boolean interplanetaryFlag = NorthstarPlanets.isInterplanetary((ResourceKey<Level>)this.f_58857_.m_46472_(), this.target);
        if (interplanetaryFlag && contraption.hasInterplanetaryNavigation) {
            interplanetaryFlag = false;
        }
        if (interplanetaryFlag) {
            contraption.owner.m_5661_((Component)Component.m_237113_((String)"Interplanetary travel requires a Interplanetary Navigator!").m_130940_(ChatFormatting.RED), false);
        }
        if (engines >= requiredJets && hasStation && fuelAmount > (float)(this.fuelCost + contraption.weightCost) && (double)heatShielding >= heatCost && oxygenSealed && !interplanetaryFlag && contraption.hasControls && contraption.dest != null && contraption.dest != this.f_58857_.m_46472_()) {
            Northstar.LOGGER.debug("{}", (Object)engines);
            contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
            RocketContraptionEntity movedContraption = RocketContraptionEntity.create(this.f_58857_, (Contraption)contraption);
            BlockPos anchor = this.f_58858_;
            movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
            AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
            movedContraption.destination = this.target;
            movedContraption.auto_land_mode = contraption.hasAutoLander;
            movedContraption.home = this.f_58857_.m_46472_();
            RocketHandler.ROCKETS.add(movedContraption);
            this.f_58857_.m_7967_((Entity)movedContraption);
        } else {
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Full Fuel Cost: " + (contraption.weightCost + contraption.fuelCost))).m_130940_(ChatFormatting.GOLD), false);
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Current Fuel Supply: " + (int)contraption.fuelAmount())).m_130940_(ChatFormatting.GOLD), false);
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Estimated Return Cost: " + (contraption.weightCost + this.fuelReturnCost))).m_130940_(ChatFormatting.GOLD), false);
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Required Heat Shielding: " + heatCost)).m_130940_(ChatFormatting.YELLOW), false);
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Current Heat Shielding: " + contraption.heatShielding())).m_130940_(ChatFormatting.YELLOW), false);
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Required Engines: " + requiredJets)).m_130940_(ChatFormatting.BLUE), false);
            contraption.owner.m_5661_((Component)Component.m_237113_((String)("Current Engine Count: " + contraption.hasJetEngine())).m_130940_(ChatFormatting.BLUE), false);
            if (!oxygenSealed) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Cockpit is not sealed, or too large!").m_130940_(ChatFormatting.DARK_RED), false);
            }
            if (contraption.fuelAmount() < (float)contraption.fuelCost) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Insufficient fuel!").m_130940_(ChatFormatting.DARK_RED), false);
            }
            if ((double)contraption.heatShielding() < heatCost) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Insufficient heat shielding!").m_130940_(ChatFormatting.DARK_RED), false);
            }
            if (contraption.hasJetEngine() < requiredJets) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Not enough Jet Engines!").m_130940_(ChatFormatting.DARK_RED), false);
            }
            if (!contraption.hasControls) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"No controls present!").m_130940_(ChatFormatting.DARK_RED), false);
            }
            if (this.container.m_8020_(0).m_41619_()) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"No star map or ticket present!").m_130940_(ChatFormatting.DARK_RED), false);
            } else if (contraption.dest == null || contraption.dest == this.f_58857_.m_46472_()) {
                contraption.owner.m_5661_((Component)Component.m_237113_((String)"Invalid Target!").m_130940_(ChatFormatting.DARK_RED), false);
            }
            contraption.owner.m_5661_((Component)Component.m_237113_((String)"Rocket failed to assemble!").m_130940_(ChatFormatting.RED), false);
            Northstar.LOGGER.debug("No station or jet engine, Bruh!");
            Northstar.LOGGER.debug("Heat Cost: {}     Heat Shielding: {}", (Object)heatCost, (Object)heatShielding);
            Northstar.LOGGER.debug("Weight Cost: {}      Fuel Cost: {}", (Object)contraption.weightCost, (Object)this.fuelCost);
            this.exception(new AssemblyException((Component)Lang.translateDirect((String)"train_assembly.no_controls", (Object[])new Object[0])), -1);
        }
    }

    public boolean isAssembling() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)StationBlock.ASSEMBLING) && (Boolean)state.m_61143_((Property)StationBlock.ASSEMBLING) != false;
    }

    public int fuelCalc() {
        String home = NorthstarPlanets.getPlanetName((ResourceKey<Level>)this.f_58857_.m_46472_());
        String targ = NorthstarPlanets.getPlanetName(this.target);
        int home_x = (int)NorthstarPlanets.getPlanetX(home);
        int home_y = (int)NorthstarPlanets.getPlanetY(home);
        int targ_x = (int)NorthstarPlanets.getPlanetX(targ);
        int targ_y = (int)NorthstarPlanets.getPlanetY(targ);
        int dif = (int)(Math.pow(home_x - targ_x, 2.0) + Math.pow(home_y - targ_y, 2.0));
        dif = Mth.m_144941_((int)dif, (int)100) / 20;
        int cost = dif + NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)this.f_58857_.m_46472_()) + 1000;
        return cost * 8;
    }

    public int fuelReturnCalc() {
        String home = NorthstarPlanets.getPlanetName((ResourceKey<Level>)this.f_58857_.m_46472_());
        String targ = NorthstarPlanets.getPlanetName(this.target);
        int home_x = (int)NorthstarPlanets.getPlanetX(home);
        int home_y = (int)NorthstarPlanets.getPlanetY(home);
        int targ_x = (int)NorthstarPlanets.getPlanetX(targ);
        int targ_y = (int)NorthstarPlanets.getPlanetY(targ);
        int dif = (int)(Math.pow(home_x - targ_x, 2.0) + Math.pow(home_y - targ_y, 2.0));
        dif = Mth.m_144941_((int)dif, (int)100) / 20;
        int cost = dif + NorthstarPlanets.getPlanetAtmosphereCost(this.target) + 1000;
        return cost * 8;
    }

    public int engineCalc() {
        double homeConstant;
        double constant;
        double homeGrav;
        int homeAtmos = NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)this.f_58857_.m_46472_()) / 100;
        int targetAtmos = NorthstarPlanets.getPlanetAtmosphereCost(this.target) / 100;
        double grav = NorthstarPlanets.getGravMultiplier(this.target);
        if (grav < (homeGrav = NorthstarPlanets.getGravMultiplier((ResourceKey<Level>)this.f_58857_.m_46472_()))) {
            grav = homeGrav;
        }
        if ((constant = NorthstarPlanets.getEngineConstant(this.target)) < (homeConstant = NorthstarPlanets.getEngineConstant((ResourceKey<Level>)this.f_58857_.m_46472_()))) {
            constant = homeConstant;
        }
        return (int)(Mth.m_14008_((double)((double)(targetAtmos + homeAtmos) * grav), (double)6.0, (double)64.0) + constant);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("item", (Tag)this.container.m_8020_(0).serializeNBT());
    }

    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        compound.m_128365_("item", (Tag)this.container.m_8020_(0).serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128425_("item", 10)) {
            this.container.m_6836_(0, ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")));
        }
    }

    private void exception(AssemblyException exception, int carriage) {
        this.failedCarriageIndex = carriage;
        this.lastException = exception;
        this.sendData();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    private boolean shouldAssemble() {
        BlockState blockState = this.m_58900_();
        return blockState.m_60734_() instanceof RocketStationBlock;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public Direction getAssemblyDirection() {
        if (this.assemblyDirection != null) {
            return this.assemblyDirection;
        }
        if (!this.edgePoint.hasValidTrack()) {
            return null;
        }
        BlockPos targetPosition = this.edgePoint.getGlobalPosition();
        BlockState trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        Direction.AxisDirection axisDirection = this.edgePoint.getTargetDirection();
        Vec3 axis = ((Vec3)track.getTrackAxes((BlockGetter)this.f_58857_, targetPosition, trackState).get(0)).m_82541_().m_82490_((double)axisDirection.m_122540_());
        this.assemblyDirection = Direction.m_122366_((double)axis.f_82479_, (double)axis.f_82480_, (double)axis.f_82481_);
        return this.assemblyDirection;
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    public void attach(ControlledContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!this.f_58857_.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public BlockPos getBlockPosition() {
        return this.f_58858_;
    }

    public void onStall() {
        if (!this.f_58857_.f_46443_) {
            this.forceMove = true;
            this.sendData();
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return RocketStationMenu.create(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Rocket Station");
    }
}

