/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.BaseTemperatureRegulator;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.contraption.ActorConfigPacket;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MovingTemperatureRegulator
implements NorthstarTemperature.Provider,
ActorConfigPacket.ITakeConfig {
    public final MovementContext context;
    public final Contraption contraption;
    public final BaseTemperatureRegulator regulator;
    public boolean active;

    MovingTemperatureRegulator(MovementContext context) {
        this.context = context;
        this.contraption = context.contraption;
        this.regulator = new BaseTemperatureRegulator();
        this.regulator.read(context.blockEntityData, context.localPos);
    }

    void tick(MovementContext context) {
        ProgressiveBlockSealer sealer = this.regulator.sealer;
        if (sealer.isSealInProgress()) {
            sealer.updateSeal((Level)context.contraption.getContraptionWorld(), (Integer)NorthstarConfigs.server().temperatureRegulatorMaxContraptionSealed.get());
        } else {
            sealer.beginSeal((Level)context.contraption.getContraptionWorld(), context.localPos, null);
        }
        if (sealer.hasLeak() && this.regulator.showLeak) {
            sealer.renderLeakPath(context.contraption.entity.m_9236_(), context.contraption.entity);
        }
        this.active = !sealer.hasLeak();
    }

    @Override
    public boolean isSealed(Vec3 pos) {
        if (!this.active) {
            return false;
        }
        Vec3 local = this.contraption.entity.toLocalVector(pos, 0.0f);
        return this.regulator.sealer.getSealedBlocks().contains(BlockPos.m_121882_((int)Mth.m_14107_((double)local.f_82479_), (int)Mth.m_14107_((double)local.f_82480_), (int)Mth.m_14107_((double)local.f_82481_)));
    }

    @Override
    public boolean isSealed(Vec3i pos) {
        return this.isSealed(Vec3.m_82528_((Vec3i)pos));
    }

    @Override
    public float getTemperature() {
        return this.regulator.temperature;
    }

    @Override
    public void handleServerConfig(CompoundTag nbt) {
        this.regulator.read(nbt, this.context.localPos);
    }
}

