/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.BaseTemperatureRegulator;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TemperatureRegulatorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
NorthstarTemperature.Provider {
    public static final int MAX_LIMIT_SIZE = 5;
    protected final BaseTemperatureRegulator regulator = new BaseTemperatureRegulator();
    protected int sealCooldown;
    protected boolean active;

    public TemperatureRegulatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.f_58857_.northstar$temperature().registerSealer(this);
    }

    public void invalidate() {
        super.invalidate();
        this.f_58857_.northstar$temperature().unregisterSealer(this);
    }

    public void destroy() {
        super.destroy();
        this.f_58857_.northstar$temperature().enqueueUpdates((LongCollection)this.regulator.sealer.getSealedBlocks());
    }

    public void tick() {
        super.tick();
        ProgressiveBlockSealer sealer = this.regulator.sealer;
        if (sealer.isSealInProgress()) {
            if (sealer.updateSeal(this.f_58857_, this.getMaximumSealedBlocks())) {
                this.sealCooldown = (Integer)NorthstarConfigs.server().sealerCheckDelay.get();
                this.f_58857_.northstar$temperature().enqueueUpdates((LongCollection)sealer.getUpdatedBlocks());
            }
        } else if (this.sealCooldown-- <= 0) {
            sealer.beginSeal(this.f_58857_, this.f_58858_, null);
        }
        sealer.renderLeakPath(this.f_58857_);
        boolean bl = this.active = Math.abs(this.speed) > 0.0f && !this.overStressed && !sealer.hasLeak();
        if (this.active && this.f_58857_.f_46443_) {
            this.addParticles(this.isCurrentlyWarm(), this.speed / 64.0f);
        }
    }

    public void onTemperatureChanged() {
        if (this.f_58857_ != null) {
            this.f_58857_.northstar$temperature().enqueueUpdates((LongCollection)this.regulator.sealer.getSealedBlocks());
        }
    }

    public int getMaximumSealedBlocks() {
        return (int)((float)((Integer)NorthstarConfigs.server().temperatureRegulatorBlocksPerRpm.get()).intValue() * Math.abs(this.speed));
    }

    public boolean isCurrentlyWarm() {
        return this.regulator.temperature >= NorthstarTemperature.getBaseTemperature(this.f_58857_, this.f_58858_);
    }

    @Override
    public boolean isSealed(Vec3 pos) {
        return this.isSealed(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)pos.f_82480_), Mth.m_14107_((double)pos.f_82481_));
    }

    @Override
    public boolean isSealed(Vec3i pos) {
        return this.isSealed(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    private boolean isSealed(int x, int y, int z) {
        return this.active && this.regulator.sealer.getSealedBlocks().contains(BlockPos.m_121882_((int)x, (int)y, (int)z));
    }

    @Override
    public float getTemperature() {
        return this.regulator.temperature;
    }

    public void addParticles(boolean isWarm, float spinMod) {
        RandomSource random = this.f_58857_.m_213780_();
        if (isWarm) {
            spinMod = 1.0f;
        }
        int j = random.m_188503_(isWarm ? 5 : 4);
        for (int i = 0; i < j; ++i) {
            SimpleParticleType particle = isWarm ? ParticleTypes.f_123744_ : (ParticleOptions)NorthstarParticles.SNOWFLAKE.get();
            double posX = (double)this.f_58858_.m_123341_() + random.m_188500_();
            double posY = (double)this.f_58858_.m_123342_() + 0.7 + random.m_188500_();
            double posZ = (double)this.f_58858_.m_123343_() + random.m_188500_();
            double velX = (double)random.m_188501_() * 0.05 * (double)(random.m_188499_() ? -1 : 1) * (double)spinMod;
            double velY = (double)random.m_188501_() * (isWarm ? 0.05 : -0.08);
            double velZ = (double)random.m_188501_() * 0.05 * (double)(random.m_188499_() ? -1 : 1) * (double)spinMod;
            this.f_58857_.m_7106_((ParticleOptions)particle, posX, posY, posZ, velX, velY, velZ);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        NorthstarLang.translate("gui.goggles.temperature_regulator", new Object[0]).forGoggles(tooltip);
        if (IRotate.StressImpact.isEnabled()) {
            this.addStressImpactStats(tooltip, this.calculateStressApplied());
        }
        NorthstarLang.translate("gui.goggles.generic.temperature", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        NorthstarLang.temperature(this.regulator.temperature).forGoggles(tooltip, 1);
        this.regulator.sealer.addToGoggleTooltip(tooltip, this.getMaximumSealedBlocks(), isPlayerSneaking);
        if (isPlayerSneaking) {
            this.regulator.sealer.addCooldownTooltip(tooltip, this.sealCooldown, this.getMaximumSealedBlocks());
        }
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.regulator.write(compound);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        float previousTemperature = this.regulator.temperature;
        super.read(compound, clientPacket);
        this.regulator.read(compound, this.f_58858_);
        if (!Mth.m_14033_((float)previousTemperature, (float)this.regulator.temperature)) {
            this.onTemperatureChanged();
        }
    }

    public ProgressiveBlockSealer getSealer() {
        return this.regulator.sealer;
    }
}

