/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.simibubi.create.content.kinetics.base.HalfShaftInstance;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.Direction;

public class TemperatureRegulatorVisual
extends HalfShaftInstance<TemperatureRegulatorBlockEntity>
implements DynamicInstance {
    private final RotatingData warmSpinner;
    private final RotatingData coldSpinner;

    public TemperatureRegulatorVisual(MaterialManager materialManager, TemperatureRegulatorBlockEntity entity) {
        super(materialManager, (KineticBlockEntity)entity);
        this.warmSpinner = ((RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.WARM_SPINNER).createInstance()).setRotationAxis(Direction.Axis.Y);
        this.coldSpinner = ((RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.COLD_SPINNER).createInstance()).setRotationAxis(Direction.Axis.Y);
    }

    protected Direction getShaftDirection() {
        return Direction.DOWN;
    }

    public void beginFrame() {
        float speed = ((TemperatureRegulatorBlockEntity)this.blockEntity).getSpeed();
        boolean warm = ((TemperatureRegulatorBlockEntity)this.blockEntity).isCurrentlyWarm();
        this.warmSpinner.setPosition(this.getInstancePosition()).nudge(0.0f, warm ? 0.0f : 1.0E8f, 0.0f).setRotationalSpeed(speed / 2.0f);
        this.coldSpinner.setPosition(this.getInstancePosition()).nudge(0.0f, warm ? 1.0E8f : 0.0f, 0.0f).setRotationalSpeed(speed / 2.0f);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.warmSpinner, this.coldSpinner});
    }

    public void remove() {
        super.remove();
        this.warmSpinner.delete();
        this.coldSpinner.delete();
    }
}

