/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.client.renderer.armor;

import com.jozufozu.flywheel.core.PartialModel;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpaceSuitLayerRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public SpaceSuitLayerRenderer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        PartialModel model;
        if (entity.m_20089_() == Pose.SLEEPING) {
            return;
        }
        ItemStack item = entity.m_6844_(EquipmentSlot.HEAD);
        if (item.m_150930_((Item)NorthstarItems.BROKEN_IRON_SPACE_SUIT_HELMET.get())) {
            model = NorthstarPartialModels.BROKEN_IRON_SPACE_SUIT_HELMET;
        } else if (item.m_150930_((Item)NorthstarItems.IRON_SPACE_SUIT_HELMET.get())) {
            model = NorthstarPartialModels.IRON_SPACE_SUIT_HELMET;
        } else if (item.m_150930_((Item)NorthstarItems.MARTIAN_STEEL_SPACE_SUIT_HELMET.get())) {
            model = NorthstarPartialModels.MARTIAN_STEEL_SPACE_SUIT_HELMET;
        } else {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        BlockState air = Blocks.f_50016_.m_49966_();
        RenderType renderType = Sheets.m_110792_();
        SuperByteBuffer helmet = CachedBufferer.partial((PartialModel)model, (BlockState)air);
        ms.m_85836_();
        if (entityModel.f_102610_) {
            ms.m_85841_(0.75f, 0.75f, 0.75f);
            ms.m_252880_(0.0f, 1.0f, 0.0f);
        }
        ((HumanoidModel)entityModel).f_102808_.m_104299_(ms);
        ms.m_85837_(0.5, 1.45, -0.5);
        ms.m_85841_(-1.0f, -1.0f, 1.0f);
        helmet.forEntityRender().light(light).renderInto(ms, buffer.m_6299_(renderType));
        ms.m_85849_();
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            SpaceSuitLayerRenderer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            SpaceSuitLayerRenderer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.m_7200_() instanceof HumanoidModel)) {
            return;
        }
        SpaceSuitLayerRenderer layer = new SpaceSuitLayerRenderer(livingRenderer);
        livingRenderer.m_115326_(layer);
    }
}

