/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.jei.category;

import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.contraption.FuelType;
import com.lightning.northstar.util.BackportUtil;
import com.lightning.northstar.util.NorthstarLang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FuelTypeCategory
extends AbstractRecipeCategory<FuelType> {
    public static final RecipeType<FuelType> RECIPE_TYPE = RecipeType.create((String)"northstar", (String)"fuel_type", FuelType.class);
    public static final int WIDTH = 142;
    public static final int HEIGHT = 60;

    public FuelTypeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.m_237113_((String)"Fuel Type"), guiHelper.createDrawableItemLike(NorthstarBlocks.JET_ENGINE), 142, 60);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelType recipe, IFocusGroup focuses) {
        List<FluidStack> fluids = RegistryUtil.getRegistryAccess().m_175515_(Registries.f_256808_).m_123024_().filter(recipe::supports).map(fluid -> new FluidStack(fluid, 1)).toList();
        BackportUtil.addFluidSlot(builder, 5, 5, RecipeIngredientRole.INPUT).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fluids);
    }

    public void draw(FuelType recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        Font font = Minecraft.m_91087_().f_91062_;
        ArrayList tooltip = new ArrayList();
        NorthstarLang.text("Combustion Engine:").forGoggles(tooltip);
        NorthstarLang.text("Usage: ").add(NorthstarLang.number(recipe.combustionEngineUse()).add(NorthstarLang.MB_PER_TICK).style(ChatFormatting.GOLD)).forGoggles(tooltip, 1);
        NorthstarLang.text("Speed: ").add(NorthstarLang.number(recipe.combustionEngineRpm()).text(" RPM").style(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        NorthstarLang.text("Rocket Engine:").forGoggles(tooltip);
        NorthstarLang.text("Energy: ").add(NorthstarLang.number(recipe.gjPerMb()).text(" gJ/mB").style(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        int y = 5;
        for (Component line : tooltip) {
            graphics.m_280430_(font, line, 20, y, -1);
            y += 10;
        }
    }
}

