/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.kubejs.recipe;

import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;

public interface EngravingRecipeSchema {
    public static final RecipeKey<InputItem[]> INGREDIENTS = ItemComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<OutputItem[]> RESULTS = ItemComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeKey<Long> TIME = TimeComponent.TICKS.key("processingTime").optional((Object)100L);
    public static final RecipeConstructor.Factory FACTORY = (recipe, schemaType, keys, from) -> {
        InputItem[] input = (InputItem[])from.getValue(recipe, INGREDIENTS);
        if (input.length != 1) {
            throw new RecipeExceptionJS("Engraving recipes must have exactly 1 item input");
        }
        OutputItem[] output = (OutputItem[])from.getValue(recipe, RESULTS);
        if (output.length != 1) {
            throw new RecipeExceptionJS("Engraving recipes require 1 item result");
        }
        recipe.setValue(INGREDIENTS, (Object)input);
        recipe.setValue(RESULTS, (Object)output);
        recipe.setValue(TIME, (Object)((Long)from.getValue(recipe, TIME)));
    };
    public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{RESULTS, INGREDIENTS, TIME}).constructor(FACTORY, new RecipeKey[]{RESULTS, INGREDIENTS, TIME});
}

