/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.content;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class NorthstarCreativeModeTab {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"northstar");
    public static final RegistryObject<CreativeModeTab> ITEMS = CREATIVE_TABS.register("northstar_items", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.northstar.items")).m_257737_(() -> new ItemStack((ItemLike)NorthstarItems.MARTIAN_STEEL.get())).m_257501_(NorthstarCreativeModeTab.createItemDisplay(ITEMS)).m_257652_());
    public static final RegistryObject<CreativeModeTab> BLOCKS = CREATIVE_TABS.register("northstar_blocks", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.northstar.blocks")).m_257737_(() -> new ItemStack((ItemLike)NorthstarBlocks.MARTIAN_STEEL_BLOCK.get())).m_257501_(NorthstarCreativeModeTab.createItemDisplay(BLOCKS)).m_257652_());
    public static final RegistryObject<CreativeModeTab> TECH = CREATIVE_TABS.register("northstar_tech", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.northstar.tech")).m_257737_(() -> new ItemStack((ItemLike)NorthstarBlocks.TELESCOPE.get())).m_257501_(NorthstarCreativeModeTab.createItemDisplay(TECH)).m_257652_());

    private static CreativeModeTab.DisplayItemsGenerator createItemDisplay(RegistryObject<CreativeModeTab> tab) {
        return (parameters, output) -> {
            Map<Item, Consumer<CreativeModeTab.Output>> builders = Map.of((Item)NorthstarItems.STAR_MAP.get(), out -> {
                NorthstarCreativeModeTab.registerStarMap(out, "earth");
                NorthstarCreativeModeTab.registerStarMap(out, "moon");
                NorthstarCreativeModeTab.registerStarMap(out, "mars");
                NorthstarCreativeModeTab.registerStarMap(out, "mercury");
                NorthstarCreativeModeTab.registerStarMap(out, "venus");
            }, (Item)NorthstarItems.IRON_SPACE_SUIT_CHESTPIECE.get(), out -> NorthstarCreativeModeTab.registerSpaceSuit(out, (Item)NorthstarItems.IRON_SPACE_SUIT_CHESTPIECE.get()), (Item)NorthstarItems.MARTIAN_STEEL_SPACE_SUIT_CHESTPIECE.get(), out -> NorthstarCreativeModeTab.registerSpaceSuit(out, (Item)NorthstarItems.MARTIAN_STEEL_SPACE_SUIT_CHESTPIECE.get()));
            for (RegistryEntry item : Northstar.REGISTRATE.getAll(Registries.f_256913_)) {
                if (item.get() instanceof SequencedAssemblyItem || !CreateRegistrate.isInCreativeTab((RegistryEntry)item, (RegistryObject)tab)) continue;
                output.m_246326_((ItemLike)item.get());
                Consumer<CreativeModeTab.Output> factory = builders.get(item.get());
                if (factory == null) continue;
                factory.accept(output);
            }
        };
    }

    private static void registerStarMap(CreativeModeTab.Output event, String planet) {
        ItemStack item = new ItemStack((ItemLike)NorthstarItems.STAR_MAP.get());
        item.m_41714_((Component)Component.m_237115_((String)("item.northstar.star_map_" + planet)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(false))));
        item.m_41698_("Planet").m_128359_("name", planet);
        event.m_246342_(item);
    }

    private static void registerSpaceSuit(CreativeModeTab.Output event, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Oxygen", 1800);
        event.m_246342_(stack);
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_TABS.register(eventBus);
    }
}

