/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarEntityTypes;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.contraption.rocket.RocketAirSound;
import com.lightning.northstar.contraption.rocket.RocketContraption;
import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.contraption.rocket.packet.RocketContraptionQuickSyncPacket;
import com.lightning.northstar.contraption.rocket.packet.RocketContraptionSyncPacket;
import com.lightning.northstar.contraption.rocket.packet.RocketControlPacket;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class RocketContraptionEntity
extends AbstractContraptionEntity
implements IEntityAdditionalSpawnData {
    public static final int LAUNCH_COUNTDOWN_TIME = 200;
    private static final float MAX_SPEED = 5.0f;
    private List<Entity> entitiesWithinContraption = List.of();
    public boolean auto_land_mode;
    public boolean launchingMode;
    public boolean landingMode;
    boolean fuelBurned = false;
    boolean printed = false;
    public boolean blasting = false;
    public boolean slowing = false;
    public boolean hasExploded = false;
    public boolean isUsingTicket = false;
    int i = 90;
    int soundTime = 0;
    int cooldown = 0;
    int cooldownLength = 100;
    private int launchTime = 0;
    private boolean activeLaunch = false;
    public Player owner;
    public UUID ownerID;
    public float lift_vel;
    public float final_lift_vel = this.lift_vel;
    public ResourceKey<Level> home;
    public ResourceKey<Level> destination;
    private int transportDelay;
    @OnlyIn(value=Dist.CLIENT)
    private RocketAirSound flyingSound;

    public RocketContraptionEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19811_ = true;
        this.lift_vel = 0.5f;
        this.launchingMode = true;
        this.landingMode = false;
    }

    public static RocketContraptionEntity create(Level world, Contraption contraption) {
        RocketContraptionEntity entity = new RocketContraptionEntity((EntityType)NorthstarEntityTypes.ROCKET_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        return entity;
    }

    public void disassemble() {
        super.disassemble();
        RocketHandler.ROCKETS.remove((Object)this);
    }

    protected void tickContraption() {
        Level level = this.m_9236_();
        if (!level.m_46472_().equals(this.destination)) {
            if (this.m_20186_() >= 1750.0) {
                this.transportDelay = Math.min(40, this.transportDelay + 1);
                if (this.transportDelay == 40 && level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    this.m_5489_(sl.m_7654_().m_129880_(this.destination));
                }
            }
        } else {
            this.transportDelay = Math.max(0, this.transportDelay - 1);
        }
        RocketContraption contraption = this.getContraption();
        this.tickActors();
        this.entitiesWithinContraption = level.m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 20.0, 1.0));
        for (Entity entity : this.entitiesWithinContraption) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            player.northstar$setPositionRelativeTo((Entity)this);
        }
        if (this.launchTime > 0 && this.activeLaunch) {
            --this.launchTime;
        }
        if (this.launchingMode && this.launchTime == 0 && this.activeLaunch) {
            if (!this.blasting) {
                this.blasting = true;
            }
            if (!this.fuelBurned) {
                if (contraption.fuelAmount() < (float)contraption.fuelCost) {
                    this.disassemble();
                } else {
                    contraption.burnFuel();
                    this.fuelBurned = true;
                }
            }
        }
        if (this.owner == null) {
            if (contraption.owner != null) {
                this.owner = ((RocketContraption)this.contraption).owner;
            }
            if (this.ownerID != null) {
                this.owner = level.m_46003_(this.ownerID);
            }
        }
        if (contraption.isUsingTicket) {
            this.isUsingTicket = true;
        }
        if (level.f_46443_) {
            if (Math.abs(this.final_lift_vel) > 0.5f && NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)level.m_46472_()) != 0) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickAirSound());
            }
        } else {
            if (this.f_19797_ % 40 == 0) {
                this.writeSyncPacket();
            }
            if (this.landingMode) {
                NorthstarPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new RocketContraptionQuickSyncPacket(this.slowing, this.m_19879_()));
            }
        }
        if (contraption.owner != null && !this.printed) {
            this.displayInfo();
            this.printed = true;
        }
        if (this.destination == null) {
            Northstar.LOGGER.error("Rocket destination is null. Setting destination to overworld");
            this.destination = Level.f_46428_;
        }
        if (this.launchingMode) {
            if (this.blasting) {
                this.lift_vel += this.lift_vel * 0.005f;
                this.lift_vel = Mth.m_14036_((float)this.lift_vel, (float)0.5f, (float)5.0f);
                this.final_lift_vel = this.lift_vel - 0.5f;
            }
            if (this.m_20186_() > 1750.0) {
                if (level.f_46443_) {
                    this.flyingSound.stopSound();
                }
                this.startLanding();
                this.cooldown = 0;
                this.final_lift_vel = 0.0f;
            }
            if (this.soundTime % 40 == 0 && this.launchTime == 0 && this.blasting) {
                level.m_7785_(this.m_20185_(), this.m_20186_() - 20.0, this.m_20189_(), (SoundEvent)NorthstarSounds.ROCKET_BLAST.get(), SoundSource.BLOCKS, 0.5f, 0.0f, false);
                this.i = 0;
                this.soundTime = 0;
            } else {
                ++this.soundTime;
            }
        } else if (this.landingMode) {
            if (this.auto_land_mode && this.m_20186_() < this.getSlowdownHeightThreshold()) {
                this.slowing = true;
            }
            if (this.slowing) {
                level.m_7785_(this.m_20185_(), this.m_20186_() - 8.0, this.m_20189_(), (SoundEvent)NorthstarSounds.ROCKET_LANDING.get(), SoundSource.BLOCKS, 0.5f, 0.0f, false);
                this.i = 0;
                this.soundTime = 0;
            }
            if (this.cooldown <= this.cooldownLength) {
                ++this.cooldown;
            }
            if (this.cooldown >= this.cooldownLength) {
                this.lift_vel = !this.slowing ? (this.lift_vel -= 0.02f) : (this.lift_vel -= this.lift_vel / 10.0f);
                this.final_lift_vel = this.lift_vel = Mth.m_14036_((float)this.lift_vel, (float)-5.0f, (float)-0.5f);
            }
        }
        this.tickActors();
        if (this.isLaunchingOrLanding() && this.collidesWithBlocks(this.landingMode ? Direction.DOWN : Direction.UP)) {
            if (!level.f_46443_) {
                level.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), AllSoundEvents.STEAM.getMainEvent(), SoundSource.BLOCKS, 0.5f, 0.0f, true);
                if (Math.abs(this.final_lift_vel) < 3.0f || this.hasExploded) {
                    if (this.landingMode && !this.isUsingTicket) {
                        ItemStack returnTicket = this.createReturnTicket();
                        if (this.owner != null) {
                            Player player = this.owner;
                            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), returnTicket));
                        }
                    }
                    this.move(0.0, -1.0, 0.0);
                    this.disassemble();
                    this.final_lift_vel = 0.0f;
                    if (this.landingMode && this.isUsingTicket) {
                        RocketHandler.deleteTicket(level, this.m_20183_());
                    }
                    this.landingMode = false;
                }
                if (this.landingMode && !this.auto_land_mode && Math.abs(this.final_lift_vel) > 3.0f && !this.hasExploded) {
                    level.m_255391_((Entity)this, this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_(), 30.0f, NorthstarPlanets.getPlanetOxy(this.destination), Level.ExplosionInteraction.MOB);
                    this.hasExploded = true;
                }
            } else if (this.flyingSound != null) {
                this.flyingSound.stopSound();
            }
        }
        if (!this.isStalled() && this.f_19797_ > 2 && this.transportDelay == 0) {
            this.move(0.0, this.final_lift_vel, 0.0);
            for (Entity entity : this.entitiesWithinContraption) {
                if (contraption.getSeatOf(entity.m_20148_()) != null) continue;
                entity.m_6034_(entity.m_20185_(), entity.m_20186_() + (double)this.final_lift_vel, entity.m_20189_());
            }
        }
        this.slowing = false;
    }

    private void writeSyncPacket() {
        RocketContraptionSyncPacket packet = new RocketContraptionSyncPacket(this.m_19879_(), this.m_20182_(), this.lift_vel, this.launchTime, this.launchingMode, this.landingMode, this.blasting, this.slowing, this.activeLaunch);
        NorthstarPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)packet);
    }

    private void displayInfo() {
        RocketContraption contraption = this.getContraption();
        double heatCost = NorthstarTemperature.getHeatRating(this.destination) * (double)((RocketContraption)this.contraption).blockCount + NorthstarTemperature.getHeatConstant(this.destination);
        double heatCostHome = NorthstarTemperature.getHeatRating((ResourceKey<Level>)this.m_9236_().m_46472_()) * (double)((RocketContraption)this.contraption).blockCount + NorthstarTemperature.getHeatConstant((ResourceKey<Level>)this.m_9236_().m_46472_());
        if (heatCostHome > heatCost) {
            heatCost = heatCostHome;
        }
        int requiredJets = contraption.fuelCost / 800;
        int fuelCost = (int)((float)contraption.weightCost + ((float)contraption.fuelCost - (float)contraption.fuelCost * contraption.computingPower));
        contraption.owner.m_5661_((Component)Component.m_237113_((String)("Fuel: " + (int)contraption.fuelAmount() + "; Required: " + fuelCost)).m_130940_(ChatFormatting.GOLD), false);
        contraption.owner.m_5661_((Component)Component.m_237113_((String)("Return Fuel Cost: ~" + contraption.fuelReturnCost)).m_130940_(ChatFormatting.GOLD), false);
        contraption.owner.m_5661_((Component)Component.m_237113_((String)("Heat Shielding: " + contraption.heatShielding() + "; Required: " + (int)Math.ceil(heatCost))).m_130940_(ChatFormatting.YELLOW), false);
        contraption.owner.m_5661_((Component)Component.m_237113_((String)("Engine Count: " + contraption.hasJetEngine() + "; Required: " + requiredJets)).m_130940_(ChatFormatting.BLUE), false);
        if (this.auto_land_mode) {
            contraption.owner.m_5661_((Component)Component.m_237113_((String)"Auto Landing Mode Enabled!").m_130940_(ChatFormatting.GREEN), false);
        }
        contraption.owner.m_5661_((Component)Component.m_237113_((String)"All entities should remain seated for the duration of the flight!").m_130940_(ChatFormatting.AQUA), false);
    }

    @Nullable
    public Entity m_5489_(ServerLevel destination) {
        return this.changeDimension(destination, new ITeleporter(){

            public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(entity.m_20182_(), Vec3.f_82478_, entity.m_146909_(), entity.m_146908_());
            }
        });
    }

    @Nullable
    public Entity changeDimension(ServerLevel destination, ITeleporter teleporter) {
        record PassengerData(Entity entity, Vec3 offset, int seat) {
        }
        ArrayList<PassengerData> passengers = new ArrayList<PassengerData>();
        UUID controllingPlayer = this.getControllingPlayer().orElse(null);
        for (Entity passenger : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(2.0, 50.0, 2.0))) {
            Vec3 offset = passenger.m_20182_().m_82546_(this.m_20182_());
            int seat = this.contraption.getSeats().indexOf(this.contraption.getSeatOf(passenger.m_20148_()));
            passengers.add(new PassengerData(passenger, offset, seat));
        }
        RocketContraptionEntity newRocket = (RocketContraptionEntity)super.changeDimension(destination, teleporter);
        if (newRocket == null) {
            return null;
        }
        newRocket.transportDelay = 40;
        for (PassengerData data : passengers) {
            Entity newPassenger = data.entity.changeDimension(destination, teleporter);
            if (newPassenger == null) continue;
            newPassenger.m_146884_(newRocket.m_20182_().m_82549_(data.offset));
            if (data.seat == -1) continue;
            newRocket.addSittingPassenger(newPassenger, data.seat);
        }
        if (controllingPlayer != null) {
            NorthstarPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new RocketControlPacket(controllingPlayer, this.m_19879_(), this.getContraption().localControlsPos));
        }
        return newRocket;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickAirSound() {
        if (this.m_9236_().f_46443_) {
            float pitch = (float)Mth.m_14008_((double)this.m_20184_().m_82553_(), (double)0.2f, (double)3.0);
            if (this.flyingSound == null || this.flyingSound.m_7801_()) {
                this.flyingSound = new RocketAirSound(SoundEvents.f_11886_, pitch, this);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.flyingSound);
            }
            this.flyingSound.setPitch(pitch);
            this.flyingSound.fadeIn(0.5f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleSyncPacket(RocketContraptionSyncPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.contraptionEntityId);
        if (!(entity instanceof RocketContraptionEntity)) {
            return;
        }
        RocketContraptionEntity rce = (RocketContraptionEntity)entity;
        rce.lift_vel = packet.lift_vel;
        rce.launchTime = packet.launchTime;
        rce.launchingMode = packet.launched;
        rce.landingMode = packet.landing;
        rce.blasting = packet.blasting;
        rce.slowing = packet.slowing;
        rce.activeLaunch = packet.activeLaunch;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleQuickSyncPacket(RocketContraptionQuickSyncPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.contraptionEntityId);
        if (!(entity instanceof RocketContraptionEntity)) {
            return;
        }
        RocketContraptionEntity rce = (RocketContraptionEntity)entity;
        rce.slowing = packet.slowing;
    }

    public ItemStack createReturnTicket() {
        ItemStack result = new ItemStack((ItemLike)NorthstarItems.RETURN_TICKET.get());
        result.m_41714_((Component)Component.m_237115_((String)("item.northstar.return_ticket_" + NorthstarPlanets.getPlanetName(this.home))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(false))));
        CompoundTag tag = result.m_41698_("Planet");
        tag.m_128359_("name", NorthstarPlanets.getPlanetName(this.home));
        return result;
    }

    public void startLanding() {
        this.launchingMode = false;
        this.landingMode = true;
        this.lift_vel = 0.0f;
    }

    public Component getContraptionName() {
        Contraption contraption = this.contraption;
        if (contraption instanceof RocketContraption) {
            RocketContraption rc = (RocketContraption)contraption;
            return Component.m_237113_((String)rc.name);
        }
        return this.m_7755_();
    }

    public boolean startControlling(BlockPos controlsLocalPos, Player player) {
        return player != null && !player.m_5833_();
    }

    public boolean collidesWithBlocks(Direction dir) {
        if (!(this.contraption instanceof RocketContraption)) {
            return false;
        }
        return RocketContraptionEntity.isCollidingWithWorld(this.m_9236_(), this.getContraption(), BlockPos.m_274446_((Position)this.m_20182_()).m_121945_(dir), dir);
    }

    public static boolean isCollidingWithWorld(Level world, RocketContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getOrCreateColliders(world, movementDirection)) {
            BlockPos colliderPos = pos.m_121955_((Vec3i)anchor);
            BlockState collidedState = world.m_8055_(colliderPos);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.m_60812_((BlockGetter)world, pos).m_83281_();
            if (collidedState.m_60734_() instanceof CocoaBlock) continue;
            MovementBehaviour movementBehaviour = AllMovementBehaviours.getBehaviour((BlockState)blockInfo.f_74676_());
            if (movementBehaviour != null) {
                if (movementBehaviour instanceof BlockBreakingMovementBehaviour) {
                    BlockBreakingMovementBehaviour behaviour = (BlockBreakingMovementBehaviour)movementBehaviour;
                    if (behaviour.canBreak(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
                if (movementBehaviour instanceof HarvesterMovementBehaviour) {
                    HarvesterMovementBehaviour harvesterMovementBehaviour = (HarvesterMovementBehaviour)movementBehaviour;
                    if (harvesterMovementBehaviour.isValidCrop(world, colliderPos, collidedState) || harvesterMovementBehaviour.isValidOther(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
            }
            if (collidedState.m_247087_() || emptyCollider) continue;
            return true;
        }
        return false;
    }

    public boolean control(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        if (player.m_5833_() || !this.toGlobalVector(VecHelper.getCenterOf((Vec3i)controlsLocalPos), 1.0f).m_82509_((Position)player.m_20182_(), 8.0) || heldControls.contains(5)) {
            return false;
        }
        boolean spaceDown = heldControls.contains(4);
        if (spaceDown && this.launchingMode && this.launchTime == 0 && !this.blasting) {
            this.startLaunchSequence();
        }
        if (spaceDown && this.landingMode) {
            this.slowing = true;
        }
        return true;
    }

    public void startLaunchSequence() {
        this.launchTime = 200;
        this.activeLaunch = true;
    }

    public void cancelLaunch() {
        this.launchTime = 0;
        this.activeLaunch = false;
    }

    public boolean clientControl(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        if (player == null || player.m_5833_() || controlsLocalPos == null || !this.toGlobalVector(VecHelper.getCenterOf((Vec3i)controlsLocalPos), 1.0f).m_82509_((Position)player.m_20182_(), 8.0) || heldControls.contains(5)) {
            return false;
        }
        boolean spaceDown = heldControls.contains(4);
        if (spaceDown && this.launchingMode && this.launchTime == 0 && !this.blasting) {
            this.startLaunchSequence();
        }
        if (spaceDown && this.landingMode) {
            this.slowing = true;
        }
        return true;
    }

    public boolean isLaunchingOrLanding() {
        return this.blasting || this.landingMode;
    }

    public boolean isActiveLaunch() {
        return this.activeLaunch;
    }

    public int getLaunchTime() {
        return this.launchTime;
    }

    public double getSlowdownHeightThreshold() {
        return this.m_9236_().m_151558_() + 150;
    }

    public List<Entity> getEntitiesWithinContraption() {
        return this.entitiesWithinContraption;
    }

    public RocketContraption getContraption() {
        return (RocketContraption)this.contraption;
    }

    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        compound.m_128379_("blasting", this.blasting);
        compound.m_128379_("slowing", this.slowing);
        compound.m_128379_("isUsingTicket", this.isUsingTicket);
        compound.m_128379_("launched", this.launchingMode);
        compound.m_128379_("landing", this.landingMode);
        compound.m_128379_("fuelBurned", this.fuelBurned);
        compound.m_128379_("printed", this.printed);
        compound.m_128379_("activeLaunch", this.activeLaunch);
        compound.m_128379_("isUsingTicket", this.isUsingTicket);
        compound.m_128359_("home", NorthstarPlanets.getPlanetName(this.home));
        compound.m_128359_("destination", NorthstarPlanets.getPlanetName(this.destination));
        if (this.owner != null) {
            compound.m_128362_("player", this.owner.m_20148_());
        }
        compound.m_128350_("lift_vel", this.lift_vel);
        compound.m_128350_("final_lift_vel", this.final_lift_vel);
        compound.m_128379_("auto_land", this.auto_land_mode);
    }

    protected void readAdditional(CompoundTag compound, boolean spawnData) {
        super.readAdditional(compound, spawnData);
        this.blasting = compound.m_128441_("blasting") && compound.m_128471_("SequencedOffsetLimit");
        this.slowing = compound.m_128441_("slowing") && compound.m_128471_("slowing");
        this.isUsingTicket = compound.m_128441_("isUsingTicket") && compound.m_128471_("isUsingTicket");
        this.launchingMode = compound.m_128441_("launched") && compound.m_128471_("launched");
        this.landingMode = compound.m_128441_("landing") && compound.m_128471_("landing");
        this.fuelBurned = compound.m_128441_("fuelBurned") && compound.m_128471_("fuelBurned");
        this.printed = compound.m_128441_("printed") && compound.m_128471_("printed");
        this.activeLaunch = compound.m_128441_("activeLaunch") && compound.m_128471_("activeLaunch");
        boolean bl = this.isUsingTicket = compound.m_128441_("isUsingTicket") && compound.m_128471_("isUsingTicket");
        if (compound.m_128441_("home")) {
            this.home = NorthstarPlanets.getPlanetDimension(compound.m_128461_("home"));
        }
        if (compound.m_128441_("destination")) {
            this.destination = NorthstarPlanets.getPlanetDimension(compound.m_128461_("destination"));
        }
        if (compound.m_128441_("player")) {
            this.ownerID = compound.m_128342_("player");
        }
        if (compound.m_128441_("lift_vel")) {
            this.lift_vel = compound.m_128457_("lift_vel");
        }
        if (compound.m_128441_("final_lift_vel")) {
            this.final_lift_vel = compound.m_128457_("final_lift_vel");
        }
        this.auto_land_mode = compound.m_128441_("auto_land") && compound.m_128471_("auto_land");
    }

    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(BlockPos.m_274446_((Position)this.getAnchorVec().m_82520_(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    protected float getStalledAngle() {
        return 0.0f;
    }

    public void m_6021_(double x, double y, double z) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    protected void handleStallInformation(double x, double y, double z, float angle) {
        this.m_20343_(x, y, z);
    }

    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyLocalTransforms(PoseStack matrixStack, float partialTicks) {
        TransformStack.cast((PoseStack)matrixStack).nudge(this.m_19879_());
    }
}

