/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public interface Mod {
    public String getModId();

    default public ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)path);
    }

    default public boolean isLoaded() {
        return ModList.get().isLoaded(this.getModId());
    }

    default public <T> Optional<T> runIfLoaded(Supplier<Supplier<T>> action) {
        return this.isLoaded() ? Optional.ofNullable(action.get().get()) : Optional.empty();
    }

    default public void executeIfLoaded(Supplier<Runnable> action) {
        if (this.isLoaded()) {
            action.get().run();
        }
    }

    default public Block getBlock(String id) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(this.loc(id));
    }

    default public Item getItem(String id) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(this.loc(id));
    }
}

