/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data.util;

import com.lightning.northstar.block.simple.VerticalSlabBlock;
import com.lightning.northstar.block.simple.VerticalSlabType;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class NorthstarDataGenModels {
    public static <I extends Item> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> itemGeneratedItem() {
        return (c, p) -> p.generated(() -> ((DataGenContext)c).get(), new ResourceLocation[]{p.modLoc("item/" + c.getName())});
    }

    public static <I extends Item> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> itemGeneratedBlock() {
        return (c, p) -> p.generated(() -> ((DataGenContext)c).get(), new ResourceLocation[]{p.modLoc("block/" + c.getName())});
    }

    public static <I extends Item> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> itemGeneratedBlock(String ... suffix) {
        return (c, p) -> p.generated(() -> ((DataGenContext)c).get(), new ResourceLocation[]{p.modLoc("block/" + c.getName() + String.join((CharSequence)"", suffix))});
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> manualModel() {
        return (c, p) -> {};
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> cubeAllTranslucent() {
        return NorthstarDataGenModels.cubeAll("translucent");
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> cubeAllCutoutMipped() {
        return NorthstarDataGenModels.cubeAll("cutout_mipped");
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> cubeAll(String renderType) {
        return (c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().cubeAll(c.getName(), p.blockTexture((Block)c.get()))).renderType(renderType));
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> cross() {
        return (c, p) -> p.models().cross(c.getName(), p.blockTexture((Block)c.get()));
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> crossCutoutMipped() {
        return NorthstarDataGenModels.cross("cutout_mipped");
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> cross(String renderType) {
        return (c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().cross(c.getName(), p.blockTexture((Block)c.get()))).renderType(renderType));
    }

    public static <B extends LanternBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> lantern() {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)p.models().singleTexture(c.getName(), p.mcLoc("block/template_lantern"), "lantern", p.blockTexture((Block)c.get()))).renderType("cutout")).build()).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)p.models().singleTexture(c.getName() + "_hanging", p.mcLoc("block/template_hanging_lantern"), "lantern", p.blockTexture((Block)c.get()))).renderType("cutout")).build());
    }

    public static <B extends LeavesBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> leaves() {
        return (c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().leaves(c.getName(), p.blockTexture((Block)c.get())));
    }

    public static <B extends RotatedPillarBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> pillar() {
        return (c, p) -> p.logBlock((RotatedPillarBlock)c.get());
    }

    public static <B extends SlabBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> slab() {
        return NorthstarDataGenModels.slab("");
    }

    public static <B extends SlabBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> slab(String suffix) {
        return (c, p) -> {
            ResourceLocation name = p.modLoc("block/" + c.getName().replaceFirst("_slab$", suffix));
            p.slabBlock((SlabBlock)c.get(), name, name);
        };
    }

    public static <B extends VerticalSlabBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> verticalSlab() {
        return NorthstarDataGenModels.verticalSlab("");
    }

    public static <B extends VerticalSlabBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> verticalSlab(String suffix) {
        return (c, p) -> {
            ResourceLocation name = p.modLoc("block/" + c.getName().replaceFirst("(_slab_vertical|_vertical_slab)$", suffix));
            BlockModelBuilder slab = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), p.modLoc("block/vertical_slab"))).texture("side", name)).texture("bottom", name)).texture("top", name);
            p.getVariantBuilder((Block)c.get()).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)p.models().getExistingFile(name))}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.WEST)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 0, false)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.NORTH)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 90, false)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.EAST)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 180, false)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.SOUTH)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 270, false)});
        };
    }

    public static <B extends StairBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> stairs() {
        return NorthstarDataGenModels.stairs("");
    }

    public static <B extends StairBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> stairs(String suffix) {
        return (c, p) -> {
            ResourceLocation name = p.modLoc("block/" + c.getName().replaceFirst("_stairs$", suffix));
            p.stairsBlock((StairBlock)c.get(), name);
        };
    }

    public static <B extends WallBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> wall() {
        return NorthstarDataGenModels.wall("");
    }

    public static <B extends WallBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> wall(String suffix) {
        return (c, p) -> {
            ResourceLocation name = p.modLoc("block/" + c.getName().replaceFirst("_wall$", suffix));
            p.wallBlock((WallBlock)c.get(), name);
            p.models().wallInventory(c.getName() + "_inventory", name);
        };
    }

    public static <B extends PointedDripstoneBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> dripstone() {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            DripstoneThickness thickness = (DripstoneThickness)state.m_61143_((Property)PointedDripstoneBlock.f_154010_);
            Direction direction = (Direction)state.m_61143_((Property)PointedDripstoneBlock.f_154009_);
            String name = c.getName() + "_" + direction.m_7912_() + "_" + thickness.m_7912_();
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)p.models().cross(name, p.modLoc("block/" + name))).renderType("cutout")).build();
        });
    }

    public static <B extends MultifaceBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> multiface(String renderType) {
        return (c, p) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)p.models().singleTexture(c.getName(), p.modLoc("block/multiface_single"), "0", p.blockTexture((Block)c.get()))).renderType(renderType);
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            for (Direction dir : Iterate.directions) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(dir == Direction.DOWN ? 90 : (dir == Direction.UP ? -90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).addModel()).condition((Property)MultifaceBlock.m_153933_((Direction)dir), (Comparable[])new Boolean[]{true}).end();
            }
        };
    }
}

