/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MercuryTortoiseEntity
extends Monster
implements GeoAnimatable {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.2, AttributeModifier.Operation.ADDITION);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int eating = 0;

    public MercuryTortoiseEntity(EntityType<? extends MercuryTortoiseEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<MercuryTortoiseEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)(event.getLimbSwingAmount() * 3.0f)).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.eating > 0) {
            --this.eating;
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("munch", Animation.LoopType.PLAY_ONCE));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public static boolean tortoiseSpawnRules(EntityType<MercuryTortoiseEntity> lunargrade, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        BlockState state = level.m_8055_(pos.m_7495_());
        if (pos.m_123342_() >= surfaceY) {
            return false;
        }
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_MERCURY_BLOCKS.tag);
    }

    public void m_7822_(byte pId) {
        if (pId == 10) {
            this.eating = 40;
        }
        super.m_7822_(pId);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8024_() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_5448_() != null) {
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        super.m_8024_();
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.MERCURY_TORTOISE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MERCURY_TORTOISE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.MERCURY_TORTOISE_DIE.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        super.m_8099_();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }
}

