/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.entity.MarsToadEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraftforge.event.ForgeEventFactory;

public class EatRootsGoal
extends Goal {
    private static final Predicate<BlockState> IS_EDIBLE = BlockStatePredicate.m_61287_((Block)((Block)NorthstarBlocks.MARS_ROOTS.get()));
    private final Mob mob;
    private final Level level;
    private int eatAnimationTick;
    private boolean performedCheck = false;

    public EatRootsGoal(Mob pMob) {
        this.mob = pMob;
        this.level = pMob.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188503_(this.mob.m_6162_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = this.mob.m_20183_();
        return IS_EDIBLE.test(this.level.m_8055_(blockpos));
    }

    public void m_8056_() {
        this.eatAnimationTick = this.m_183277_(40);
        Mob mob = this.mob;
        if (mob instanceof MarsToadEntity) {
            MarsToadEntity toad = (MarsToadEntity)mob;
            toad.eating = 40;
        }
        this.level.m_7605_((Entity)this.mob, (byte)10);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatAnimationTick = 0;
    }

    public boolean m_8045_() {
        return this.eatAnimationTick > 0;
    }

    public int getEatAnimationTick() {
        return this.eatAnimationTick;
    }

    public void m_8037_() {
        BlockPos blockpos;
        if (!this.performedCheck) {
            int rootnumber = 0;
            for (BlockState state : this.level.m_45556_(this.mob.m_20191_().m_82400_(15.0)).toList()) {
                if (!state.m_60713_((Block)NorthstarBlocks.MARS_ROOTS.get())) continue;
                ++rootnumber;
            }
            if (rootnumber < 10) {
                this.m_8041_();
                return;
            }
            this.performedCheck = true;
        }
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick == this.m_183277_(4) && IS_EDIBLE.test(this.level.m_8055_(blockpos = this.mob.m_20183_()))) {
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                this.level.m_46961_(blockpos, false);
            }
            this.mob.m_8035_();
        }
    }
}

