/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.compat.copycat;

import com.copycatsplus.copycats.content.copycat.bytes.CopycatByteBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.lightning.northstar.compat.copycats.CopycatSealHelper;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.mixin.accessor.NorthstarContraptionWorld;
import com.lightning.northstar.world.sealer.SealableBlock;
import com.lightning.northstar.world.sealer.SealingMode;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={CopycatByteBlock.class})
public class CopycatByteBlockMixin
implements SealableBlock {
    @Unique
    private static final BooleanProperty[] northstar$propertiesByDirection = new BooleanProperty[24];

    @Override
    public boolean northstar$isFaceSealed(BlockGetter level, BlockPos pos, BlockState state, Direction direction, boolean source, SealingMode mode) {
        int i = direction.ordinal() * 4;
        for (int j = 0; j < 4; ++j) {
            if (((Boolean)state.m_61143_((Property)northstar$propertiesByDirection[i + j])).booleanValue()) continue;
            return false;
        }
        if (level instanceof NorthstarContraptionWorld) {
            NorthstarContraptionWorld cw = (NorthstarContraptionWorld)level;
            CompoundTag compound = CopycatSealHelper.getBlockNbt(cw, pos);
            if (compound == null) {
                return true;
            }
            for (int j = 0; j < 4; ++j) {
                if (!CopycatByteBlockMixin.northstar$isMaterialUnsealed(CopycatSealHelper.getMultistateMaterial(compound, northstar$propertiesByDirection[i + j]))) continue;
                return false;
            }
            return true;
        }
        BlockEntity compound = level.m_7702_(pos);
        if (compound instanceof IMultiStateCopycatBlockEntity) {
            IMultiStateCopycatBlockEntity be = (IMultiStateCopycatBlockEntity)compound;
            MaterialItemStorage storage = be.getMaterialItemStorage();
            for (int j = 0; j < 4; ++j) {
                if (!CopycatByteBlockMixin.northstar$isMaterialUnsealed(CopycatSealHelper.getMultistateMaterial(storage, northstar$propertiesByDirection[i + j]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Unique
    private static boolean northstar$isMaterialUnsealed(BlockState state) {
        return !AllBlocks.COPYCAT_BASE.is((Object)state.m_60734_()) && NorthstarTags.NorthstarBlockTags.AIR_PASSES_THROUGH.matches(state);
    }

    static {
        int i = 0;
        for (Direction direction : Iterate.directions) {
            boolean positive = direction.m_122421_() == Direction.AxisDirection.POSITIVE;
            Direction.Axis axis = direction.m_122434_();
            CopycatByteBlock.Byte bite = CopycatByteBlock.bite((axis == Direction.Axis.X && positive ? 1 : 0) != 0, (axis == Direction.Axis.Y && positive ? 1 : 0) != 0, (axis == Direction.Axis.Z && positive ? 1 : 0) != 0);
            for (int j = 0; j < 4; ++j) {
                CopycatByteBlockMixin.northstar$propertiesByDirection[i++] = CopycatByteBlock.byByte((CopycatByteBlock.Byte)bite);
                bite = switch (axis) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> bite.rotateX(Rotation.CLOCKWISE_90);
                    case Direction.Axis.Y -> bite.rotateY(Rotation.CLOCKWISE_90);
                    case Direction.Axis.Z -> bite.rotateZ(Rotation.CLOCKWISE_90);
                };
            }
        }
    }
}

