/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.network.packet;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RelativeTeleportPacket
extends SimplePacketBase {
    public final int entityId;
    public final Vec3 offset;

    public RelativeTeleportPacket(int entityId, Vec3 offset) {
        this.entityId = entityId;
        this.offset = offset;
    }

    public RelativeTeleportPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.offset = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.offset.f_82479_);
        buf.writeDouble(this.offset.f_82480_);
        buf.writeDouble(this.offset.f_82481_);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handle));
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handle() {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity other = minecraft.f_91073_.m_6815_(this.entityId);
        if (other != null) {
            minecraft.f_91074_.m_146884_(other.m_20182_().m_82546_(this.offset));
        }
    }
}

