/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.ColdAirParticle;
import com.lightning.northstar.particle.DustCloudParticle;
import com.lightning.northstar.particle.GlowstoneParticle;
import com.lightning.northstar.particle.LeakParticle;
import com.lightning.northstar.particle.OxyFlowParticle;
import com.lightning.northstar.particle.RocketFlameLandingParticle;
import com.lightning.northstar.particle.RocketFlameParticle;
import com.lightning.northstar.particle.RocketSmokeLandingParticle;
import com.lightning.northstar.particle.RocketSmokeParticle;
import com.lightning.northstar.particle.SnailSlimeParticle;
import com.lightning.northstar.particle.SnowflakeParticle;
import com.lightning.northstar.particle.SulfurPoofParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NorthstarParticles {
    private static final DeferredRegister<ParticleType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"northstar");
    private static final List<Consumer<RegisterParticleProvidersEvent>> FACTORIES = new ArrayList<Consumer<RegisterParticleProvidersEvent>>();
    public static final RegistryObject<SimpleParticleType> COLD_AIR = NorthstarParticles.simpleSprite("cold_air", () -> ColdAirParticle::new);
    public static final RegistryObject<SimpleParticleType> DUST_CLOUD = NorthstarParticles.simpleSprite("dust_cloud", () -> DustCloudParticle::new);
    public static final RegistryObject<SimpleParticleType> GLOWSTONE = NorthstarParticles.simpleSprite("glowstone", () -> GlowstoneParticle::new);
    public static final RegistryObject<SimpleParticleType> LEAK = NorthstarParticles.simpleSprite("leak", () -> LeakParticle::new);
    public static final RegistryObject<SimpleParticleType> OXY_FLOW = NorthstarParticles.simpleSprite("oxy_flow", () -> OxyFlowParticle::new);
    public static final RegistryObject<SimpleParticleType> ROCKET_FLAME = NorthstarParticles.simpleSprite("rocket_flame", () -> RocketFlameParticle::new);
    public static final RegistryObject<SimpleParticleType> ROCKET_FLAME_LANDING = NorthstarParticles.simpleSprite("rocket_flame_landing", () -> RocketFlameLandingParticle::new);
    public static final RegistryObject<SimpleParticleType> ROCKET_SMOKE = NorthstarParticles.simpleSprite("rocket_smoke", () -> RocketSmokeParticle::new);
    public static final RegistryObject<SimpleParticleType> ROCKET_SMOKE_LANDING = NorthstarParticles.simpleSprite("rocket_smoke_landing", () -> RocketSmokeLandingParticle::new);
    public static final RegistryObject<SimpleParticleType> SNAIL_SLIME = NorthstarParticles.simpleSprite("snail_slime", () -> SnailSlimeParticle::new);
    public static final RegistryObject<SimpleParticleType> SNOWFLAKE = NorthstarParticles.simpleSprite("snowflake", () -> SnowflakeParticle::new);
    public static final RegistryObject<SimpleParticleType> SULFUR_POOF = NorthstarParticles.simpleSprite("sulfur_poof", () -> SulfurPoofParticle::new);

    public static void register(IEventBus modEventBus) {
        REGISTER.register(modEventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        for (Consumer<RegisterParticleProvidersEvent> factory : FACTORIES) {
            factory.accept(event);
        }
        FACTORIES.clear();
    }

    private static RegistryObject<SimpleParticleType> simpleSprite(String name, Supplier<SpriteParticleProvider<SimpleParticleType>> supplier) {
        RegistryObject entry = REGISTER.register(name, () -> new SimpleParticleType(false));
        FACTORIES.add(event -> {
            SpriteParticleProvider factory = (SpriteParticleProvider)supplier.get();
            event.registerSpriteSet((ParticleType)entry.get(), sprite -> (a, b, c, d, e, f, g, h) -> factory.createParticle(a, b, c, d, e, f, g, h, sprite));
        });
        return entry;
    }

    public static int getLight(int lightColor, float partialTick, int age, int lifetime) {
        float f = Mth.m_14036_((float)(((float)age + partialTick) / (float)lifetime), (float)0.0f, (float)1.0f);
        int j = lightColor & 0xFF;
        int k = lightColor >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static interface SpriteParticleProvider<T extends ParticleOptions> {
        public Particle createParticle(T var1, ClientLevel var2, double var3, double var5, double var7, double var9, double var11, double var13, SpriteSet var15);
    }
}

