/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.util;

import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.util.TemperatureUnit;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.LangNumberFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

public class NorthstarLang {
    public static final LangBuilder MB = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
    public static final LangBuilder MB_PER_TICK = NorthstarLang.translate("generic.unit.millibuckets_per_tick", new Object[0]);

    public static LangBuilder builder() {
        return new LangBuilder("northstar");
    }

    public static LangBuilder text(String text) {
        return NorthstarLang.builder().text(text);
    }

    public static LangBuilder translate(String langKey, Object ... args) {
        return NorthstarLang.builder().translate(langKey, args);
    }

    public static LangBuilder number(double d) {
        return NorthstarLang.builder().text(LangNumberFormat.format((double)d));
    }

    public static LangBuilder temperature(double temperature) {
        TemperatureUnit unit = (TemperatureUnit)((Object)NorthstarConfigs.client().temperatureUnit.get());
        return NorthstarLang.number(unit.fromCelsius(temperature)).text(ChatFormatting.GRAY, unit.symbol).style(ChatFormatting.DARK_GREEN);
    }

    public static void addTankTooltip(List<Component> tooltip, SmartFluidTank tank) {
        NorthstarLang.addTankTooltip(tooltip, tank.getFluid(), tank.getCapacity());
    }

    public static void addTankTooltip(List<Component> tooltip, FluidStack fluid, int capacity) {
        if (!fluid.isEmpty()) {
            Lang.fluidName((FluidStack)fluid).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            Lang.translate((String)"gui.goggles.empty", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        Lang.builder().add(Lang.number((double)fluid.getAmount()).add(MB).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)capacity).add(MB).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }
}

