/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.util;

import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangNumberFormat;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.network.chat.Component;

public enum TemperatureUnit {
    CELSIUS("\u00b0C", d -> d, d -> d),
    FAHRENHEIT("\u00b0F", d -> d * 9.0 / 5.0 + 32.0, d -> (d - 32.0) * 5.0 / 9.0),
    KELVIN("K", d -> d + 273.0, d -> d - 273.0);

    public static final TemperatureUnit[] ALL;
    public final Component name = Component.m_237115_((String)("northstar.temperature_unit." + Lang.asId((String)this.name())));
    public final Component nameAndSymbol;
    public final String symbol;
    public final DoubleUnaryOperator fromCelsius;
    public final DoubleUnaryOperator toCelsius;

    private TemperatureUnit(String symbol, DoubleUnaryOperator fromCelsius, DoubleUnaryOperator toCelsius) {
        this.nameAndSymbol = this.name.m_6881_().m_130946_(" (" + symbol + ")");
        this.symbol = symbol;
        this.fromCelsius = fromCelsius;
        this.toCelsius = toCelsius;
    }

    public float fromCelsius(float celsius) {
        return (float)this.fromCelsius.applyAsDouble(celsius);
    }

    public double fromCelsius(double celsius) {
        return this.fromCelsius.applyAsDouble(celsius);
    }

    public float toCelsius(float celsius) {
        return (float)this.toCelsius.applyAsDouble(celsius);
    }

    public double toCelsius(double celsius) {
        return this.toCelsius.applyAsDouble(celsius);
    }

    public String format(float temperature) {
        return LangNumberFormat.format((double)this.fromCelsius(temperature)) + this.symbol;
    }

    public String format(double temperature) {
        return LangNumberFormat.format((double)this.fromCelsius(temperature)) + this.symbol;
    }

    static {
        ALL = TemperatureUnit.values();
    }
}

