/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.oxygen;

import com.lightning.northstar.block.tech.oxygen_sealer.OxygenSealerBlockEntity;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockUpdater;
import com.lightning.northstar.world.sealer.SealingMode;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NorthstarOxygen {
    public static final int MAXIMUM_OXYGEN = 1800;
    private final Level level;
    private final Set<Provider> providers;
    private final ProgressiveBlockUpdater updater;

    public NorthstarOxygen(Level level) {
        this.level = level;
        this.providers = new HashSet<Provider>();
        this.updater = new ProgressiveBlockUpdater(SealingMode.OXYGEN);
    }

    public boolean hasOxygen() {
        return NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.m_46472_());
    }

    public Provider getSealer(Vec3 pos) {
        for (Provider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return sealer;
        }
        return null;
    }

    public Provider getSealer(Vec3i pos) {
        for (Provider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return sealer;
        }
        return null;
    }

    public boolean hasOxygen(Vec3 pos) {
        return NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.m_46472_()) || this.getSealer(pos) != null;
    }

    public boolean hasOxygen(Vec3i pos) {
        return NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.m_46472_()) || this.getSealer(pos) != null;
    }

    public void registerSealer(Provider provider) {
        this.providers.add(provider);
    }

    public void unregisterSealer(Provider provider) {
        this.providers.remove(provider);
    }

    public void enqueueUpdates(LongCollection positions) {
        this.updater.queueUpdates(positions);
    }

    @ApiStatus.Internal
    public void processUpdates(ServerLevel level) {
        this.updater.processUpdates((Level)level);
    }

    public static boolean isOxygen(Fluid fluid) {
        return NorthstarTags.NorthstarFluidTags.C_OXYGEN.matches(fluid) || NorthstarTags.NorthstarFluidTags.BREATHABLE.matches(fluid);
    }

    public static boolean hasOxygen(Level level, Vec3 pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static boolean hasOxygen(Level level, Vec3i pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static NorthstarOxygen getDimension(Level level) {
        return level.northstar$oxygen();
    }

    public static ItemStack getOxygenTank(LivingEntity entity) {
        for (ItemStack item : entity.m_6168_()) {
            if (!item.m_204117_(NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.tag)) continue;
            return item;
        }
        return ItemStack.f_41583_;
    }

    @SubscribeEvent
    public static void onBreathe(LivingBreatheEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        if (NorthstarTags.NorthstarEntityTags.DOESNT_REQUIRE_OXYGEN.matches((Entity)entity)) {
            event.setCanBreathe(true);
            event.setCanRefillAir(true);
            return;
        }
        NorthstarOxygen oxygen = world.northstar$oxygen();
        boolean atmosphereBreathable = oxygen.hasOxygen();
        if (atmosphereBreathable && event.canBreathe()) {
            return;
        }
        Provider sealer = oxygen.getSealer(entity.m_146892_());
        if (sealer != null) {
            event.setCanBreathe(true);
            event.setCanRefillAir(true);
            sealer.drainOxygen(NorthstarConfigs.server().oxygenSealerEntityActiveDrain.getF());
            return;
        }
        boolean isFullyCovered = true;
        ItemStack oxygenSource = ItemStack.f_41583_;
        for (ItemStack armor : entity.m_6168_()) {
            if (armor.m_41619_()) {
                isFullyCovered = false;
                break;
            }
            if (!NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(armor)) continue;
            oxygenSource = armor;
        }
        if (isFullyCovered && !oxygenSource.m_41619_() && NorthstarOxygen.depleteOxygen(oxygenSource, world.m_46467_() % 20L == 0L)) {
            event.setCanBreathe(true);
            event.setCanRefillAir(true);
        } else if (!atmosphereBreathable && world.m_46467_() % 10L != (long)(entity.m_19879_() % 10)) {
            entity.m_6469_(world.m_269111_().northstar$suffocation(), 1.0f);
        }
    }

    public static boolean depleteOxygen(ItemStack stack, boolean deplete) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("Oxygen", 3)) {
            return false;
        }
        int oxygen = tag.m_128451_("Oxygen");
        if (oxygen <= 0) {
            return false;
        }
        if (deplete) {
            tag.m_128405_("Oxygen", Math.min(oxygen - 1, 1800));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPostRender(RenderLevelStageEvent event) {
        if (!((Boolean)NorthstarConfigs.client().debugSealerBounds.get()).booleanValue()) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            PoseStack pose = event.getPoseStack();
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            pose.m_85836_();
            pose.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
            for (SealingProvider sealingProvider : NorthstarOxygen.getDimension((Level)Minecraft.m_91087_().f_91073_).providers) {
                if (!(sealingProvider instanceof OxygenSealerBlockEntity)) continue;
                OxygenSealerBlockEntity sealer = (OxygenSealerBlockEntity)sealingProvider;
                sealer.getSealer().getVisualizer().render(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
            }
            pose.m_85849_();
        }
    }

    public static interface Provider
    extends SealingProvider {
        public void drainOxygen(float var1);
    }
}

