/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.sealer;

import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.util.MutableAABB;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.sealer.SealableBlock;
import com.lightning.northstar.world.sealer.SealerDebugVisualizer;
import com.lightning.northstar.world.sealer.SealerExtensionSource;
import com.lightning.northstar.world.sealer.SealingMode;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ProgressiveBlockSealer {
    private static final long START_MARKER = Long.MIN_VALUE;
    private final SealingMode mode;
    private final BlockPos.MutableBlockPos tempPos1 = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos tempPos2 = new BlockPos.MutableBlockPos();
    private final Long2LongMap visited = new Long2LongOpenHashMap();
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final MutableAABB bounds = new MutableAABB();
    private int extraCheckedVolume;
    private int extraCheckedPerTick;
    private final LongArrayList leakPath = new LongArrayList();
    private final LongSet sealedBlocks = new LongOpenHashSet();
    private final MutableAABB sealedBounds = new MutableAABB();
    private final LongList updatedBlocks = new LongArrayList();
    private boolean hasLeak;
    private int extraVolume;
    private SealerDebugVisualizer visualizer = SealerDebugVisualizer.NOOP;

    public ProgressiveBlockSealer(SealingMode mode) {
        this.mode = mode;
        this.visited.defaultReturnValue(Long.MIN_VALUE);
    }

    public boolean beginSeal(Level level, BlockPos origin, @Nullable Direction originDirection) {
        if (originDirection != null) {
            this.tempPos1.m_122159_((Vec3i)origin, originDirection);
            if (ProgressiveBlockSealer.isFaceOccluded((BlockGetter)level, (BlockPos)this.tempPos1, originDirection.m_122424_(), false, this.mode)) {
                this.sealedBounds.zero();
                this.sealedBlocks.clear();
                this.hasLeak = false;
                this.extraVolume = 0;
                this.visualizer.complete();
                return false;
            }
        } else {
            this.tempPos1.m_122190_((Vec3i)origin);
        }
        if (level.m_5776_() && (Boolean)NorthstarConfigs.client().debugSealerBounds.get() != this.visualizer instanceof SealerDebugVisualizer.Client) {
            this.visualizer = (Boolean)NorthstarConfigs.client().debugSealerBounds.get() != false ? new SealerDebugVisualizer.Client() : SealerDebugVisualizer.NOOP;
        }
        this.visited.clear();
        this.queue.clear();
        this.bounds.neg();
        this.updatedBlocks.clear();
        this.visited.put(this.tempPos1.m_121878_(), Long.MIN_VALUE);
        this.queue.enqueue(this.tempPos1.m_121878_());
        this.extraCheckedPerTick = 0;
        this.extraCheckedVolume = 0;
        this.bounds.union((Vec3i)origin);
        this.bounds.union((Vec3i)this.tempPos1);
        return true;
    }

    public boolean updateSeal(Level level, int maximumSealed) {
        return this.updateSeal(level, maximumSealed, (Integer)NorthstarConfigs.server().sealerBaseCheckBlocksPerTick.get());
    }

    public boolean updateSeal(Level level, int maximumSealed, int maximumChecked) {
        if (this.queue.isEmpty()) {
            return true;
        }
        maximumSealed += this.extraCheckedVolume;
        maximumChecked = Math.min(maximumChecked + this.extraCheckedPerTick, (Integer)NorthstarConfigs.server().sealerMaxCheckedBlocksPerTick.get());
        ProfilerFiller profiler = level.m_46473_();
        profiler.m_6180_("northstar:seal_blocks");
        long lastChecked = 0L;
        int checked = 0;
        while (!this.queue.isEmpty() && checked++ < maximumChecked && this.visited.size() <= maximumSealed) {
            long parent = this.queue.dequeueLong();
            this.tempPos1.m_122188_(parent);
            for (Direction direction : Iterate.directions) {
                BlockState state;
                Block block;
                this.tempPos2.m_122159_((Vec3i)this.tempPos1, direction);
                long packed = this.tempPos2.m_121878_();
                if (this.visited.containsKey(packed) || this.isAirOccluded((BlockGetter)level, (BlockPos)this.tempPos1, (BlockPos)this.tempPos2, direction)) continue;
                this.visited.put(packed, parent);
                this.onBlockAdded((BlockGetter)level, (BlockPos)this.tempPos2);
                if (!this.sealedBlocks.contains(packed)) {
                    this.updatedBlocks.add(packed);
                }
                if ((block = (state = level.m_8055_((BlockPos)this.tempPos2)).m_60734_()) instanceof SealerExtensionSource) {
                    SealerExtensionSource source = (SealerExtensionSource)block;
                    int sourceVolume = source.getMaximumSealedBlocks(level, (BlockPos)this.tempPos2);
                    int sourceChecked = source.getMaximumCheckedPerTick(level, (BlockPos)this.tempPos2);
                    this.extraCheckedVolume += sourceVolume;
                    this.extraCheckedPerTick += sourceChecked;
                    maximumSealed += sourceVolume;
                    maximumChecked = Math.min(maximumChecked + sourceChecked, (Integer)NorthstarConfigs.server().sealerMaxCheckedBlocksPerTick.get());
                }
                this.bounds.union((Vec3i)this.tempPos2);
                this.queue.enqueue(packed);
                lastChecked = packed;
                this.visualizer.addConnection(parent, packed);
            }
        }
        profiler.m_183275_("blocks", checked);
        if (!this.queue.isEmpty() && this.visited.size() + this.queue.size() < maximumSealed) {
            profiler.m_7238_();
            return false;
        }
        this.onSealComplete(maximumSealed, lastChecked);
        profiler.m_7238_();
        return true;
    }

    protected void onSealComplete(int maximumSealed, long lastChecked) {
        this.hasLeak = !this.queue.isEmpty() || this.visited.size() > maximumSealed;
        this.leakPath.clear();
        if (this.hasLeak) {
            while (lastChecked != Long.MIN_VALUE) {
                this.leakPath.add(lastChecked);
                lastChecked = this.visited.get(lastChecked);
            }
            this.updatedBlocks.clear();
            this.updatedBlocks.addAll((LongCollection)this.sealedBlocks);
            this.sealedBlocks.clear();
            this.sealedBounds.neg();
        } else {
            this.leakPath.trim();
            LongIterator iterator = this.sealedBlocks.longIterator();
            while (iterator.hasNext()) {
                long value = iterator.nextLong();
                if (this.visited.containsKey(value)) continue;
                this.updatedBlocks.add(value);
            }
            this.sealedBlocks.clear();
            this.sealedBlocks.addAll((LongCollection)this.visited.keySet());
            this.sealedBounds.set(this.bounds);
        }
        this.extraVolume = this.extraCheckedVolume;
        this.visualizer.complete();
        this.queue.clear();
        this.visited.clear();
        this.bounds.neg();
    }

    protected void onBlockAdded(BlockGetter level, BlockPos pos) {
    }

    protected boolean isAirOccluded(BlockGetter level, BlockPos from, BlockPos to, Direction direction) {
        return ProgressiveBlockSealer.isAirOccluded(level, from, to, direction, this.mode);
    }

    public static boolean isAirOccluded(BlockGetter level, BlockPos from, BlockPos to, Direction direction, SealingMode mode) {
        return ProgressiveBlockSealer.isFaceOccluded(level, from, direction, true, mode) || ProgressiveBlockSealer.isFaceOccluded(level, to, direction.m_122424_(), false, mode);
    }

    public static boolean isFaceOccluded(BlockGetter level, BlockPos pos, Direction direction, boolean source, SealingMode mode) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof SealableBlock) {
            SealableBlock sealable = (SealableBlock)block;
            return sealable.northstar$isFaceSealed(level, pos, state, direction, source, mode);
        }
        if (source && NorthstarTags.NorthstarBlockTags.BLOCKS_AIR.matches(state)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)state.m_60808_(level, pos), (Direction)direction) && !NorthstarTags.NorthstarBlockTags.AIR_PASSES_THROUGH.matches(state);
    }

    public void renderLeakPath(Level level) {
        this.renderLeakPath(level, null);
    }

    public void renderLeakPath(Level level, @Nullable AbstractContraptionEntity contraption) {
        if (!this.hasLeak || this.leakPath.isEmpty() || !level.f_46443_) {
            return;
        }
        BlockPos.MutableBlockPos pos = this.tempPos1;
        RandomSource random = level.f_46441_;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        int j = this.leakPath.size();
        for (int i = 0; i < j; ++i) {
            pos.m_122188_(this.leakPath.getLong(i));
            double cx = (double)pos.m_123341_() + 0.5;
            double cy = (double)pos.m_123342_() + 0.5;
            double cz = (double)pos.m_123343_() + 0.5;
            if (contraption != null) {
                Vec3 global = contraption.toGlobalVector(new Vec3(cx, cy, cz), 1.0f);
                cx = global.f_82479_;
                cy = global.f_82480_;
                cz = global.f_82481_;
            }
            if (i != 0) {
                level.m_7106_((ParticleOptions)NorthstarParticles.LEAK.get(), cx - 0.2 + (double)random.m_188501_() * 0.4, cy - 0.2 + (double)random.m_188501_() * 0.4, cz - 0.2 + (double)random.m_188501_() * 0.4, px - cx, py - cy, pz - cz);
            }
            px = cx;
            py = cy;
            pz = cz;
        }
    }

    public void addToGoggleTooltip(List<Component> tooltip, int maximumSealed, boolean isPlayerSneaking) {
        if (this.hasLeak()) {
            NorthstarLang.translate("gui.goggles.sealer.area_too_big", new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            NorthstarLang.translate("gui.goggles.sealer.max_sealed", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.number((double)(maximumSealed + this.extraVolume)).style(ChatFormatting.BLUE).text(ChatFormatting.GRAY, " blocks").forGoggles(tooltip, 1);
        } else {
            NorthstarLang.translate("gui.goggles.sealer.blocks_filled", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.number((double)this.sealedBlocks.size()).style(ChatFormatting.BLUE).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)(maximumSealed + this.extraVolume)).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        if (isPlayerSneaking && this.extraVolume != 0) {
            Lang.number((double)maximumSealed).style(ChatFormatting.BLUE).add(NorthstarLang.translate("gui.goggles.sealer.capacity_speed", new Object[0]).style(ChatFormatting.GRAY)).forGoggles(tooltip, 2);
            Lang.number((double)this.extraVolume).style(ChatFormatting.BLUE).add(NorthstarLang.translate("gui.goggles.sealer.capacity_extra", new Object[0]).style(ChatFormatting.GRAY)).forGoggles(tooltip, 2);
        }
    }

    public void addCooldownTooltip(List<Component> tooltip, int cooldown, int maximumSealed) {
        if (cooldown > 0) {
            NorthstarLang.translate("gui.goggles.sealer.cooldown", new Object[0]).style(ChatFormatting.GRAY).add(Lang.number((double)Math.round((float)cooldown / 20.0f)).style(ChatFormatting.AQUA)).forGoggles(tooltip);
        } else {
            NorthstarLang.translate("gui.goggles.sealer.sealing", new Object[0]).style(ChatFormatting.GRAY).add(Lang.number((double)(100.0 * (double)this.visited.size() / (double)(maximumSealed + this.extraCheckedVolume))).text("%").style(ChatFormatting.AQUA)).forGoggles(tooltip);
        }
    }

    public boolean isSealInProgress() {
        return !this.queue.isEmpty();
    }

    public MutableAABB getSealedBounds() {
        return this.sealedBounds;
    }

    public LongSet getSealedBlocks() {
        return this.sealedBlocks;
    }

    public LongList getUpdatedBlocks() {
        return this.updatedBlocks;
    }

    public boolean hasLeak() {
        return this.hasLeak;
    }

    public SealerDebugVisualizer getVisualizer() {
        return this.visualizer;
    }

    public int getSealedBlockCount() {
        return this.sealedBlocks.size();
    }
}

