/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.lightning.northstar.world.NorthstarOxygen;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ExtinguishedTorchWallBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final float AABB_OFFSET = 2.5f;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public ExtinguishedTorchWallBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ExtinguishedTorchWallBlock.getShape(pState);
    }

    public static VoxelShape getShape(BlockState pState) {
        return AABBS.get(pState.m_61143_((Property)FACING));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.m_122424_() == pState.m_61143_((Property)FACING) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        for (Direction direction : adirection = pContext.m_6232_()) {
            Direction direction1;
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)(direction1 = direction.m_122424_()))).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockPos blockpos = pPos.m_121945_(direction.m_122424_());
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)pLevel, blockpos, direction);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        boolean fireflag = false;
        if ((pPlayer.m_21120_(pHand).m_41720_() == Items.f_42409_ || pPlayer.m_21120_(pHand).m_41720_() == Items.f_42613_) && NorthstarOxygen.hasOxygen(pLevel, (Vec3i)pPos)) {
            fireflag = true;
        }
        if (pPlayer.m_150110_().f_35938_ && fireflag) {
            pLevel.m_7731_(pPos, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)pState.m_61143_((Property)FACING))), 64);
            pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, pLevel.m_213780_().m_188501_() * 0.4f + 0.8f);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }
}

