/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.google.common.collect.ImmutableMap;
import com.lightning.northstar.content.NorthstarBlocks;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MarsRootBlock
extends MultifaceBlock {
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().collect(Util.m_137448_());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MarsRootBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.FALSE)).m_61124_((Property)DOWN, (Comparable)Boolean.FALSE)).m_61124_((Property)NORTH, (Comparable)Boolean.FALSE)).m_61124_((Property)EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)SOUTH, (Comparable)Boolean.FALSE)).m_61124_((Property)WEST, (Comparable)Boolean.FALSE));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), MarsRootBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_57906_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_57906_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_57906_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)DOWN)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)DOWN_AABB);
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rando) {
        if (rando.m_188503_(48) == 0) {
            this.spreader.m_221619_(state, (LevelAccessor)level, pos, rando);
        }
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pNeighborPos, Direction pAttachedFace) {
        return MultifaceBlock.m_153829_((BlockGetter)pBlockReader, (Direction)pAttachedFace, (BlockPos)pNeighborPos, (BlockState)pBlockReader.m_8055_(pNeighborPos));
    }

    public static BlockState giveStateValues(LevelAccessor level, BlockPos pPos, RandomSource rando) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            BlockState block = level.m_8055_(pPos.m_121945_(dir));
            if (!block.m_60795_()) continue;
            list.add(dir);
        }
        return rando.m_188503_(4) == 0 ? (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((MarsRootBlock)((Object)NorthstarBlocks.GLOWING_MARS_ROOTS.get())).m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(list.contains(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(list.contains(Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(list.contains(Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(list.contains(Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(list.contains(Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(list.contains(Direction.WEST))) : (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((MarsRootBlock)((Object)NorthstarBlocks.MARS_ROOTS.get())).m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(list.contains(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(list.contains(Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(list.contains(Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(list.contains(Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(list.contains(Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(list.contains(Direction.WEST)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        boolean flag = blockstate.m_60713_((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.m_49966_();
        for (Direction direction : pContext.m_6232_()) {
            boolean flag1;
            BooleanProperty booleanproperty = MarsRootBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !MarsRootBlock.canSupportAtFace((BlockGetter)pContext.m_43725_(), pContext.m_8083_(), direction)) continue;
            return (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.TRUE);
        }
        return flag ? blockstate1 : null;
    }

    public static BlockState getStateForGeneration(WorldGenLevel level, BlockPos pos, RandomSource rando) {
        BlockState newState = ((MarsRootBlock)((Object)NorthstarBlocks.MARS_ROOTS.get())).m_49966_();
        if (rando.m_188503_(4) == 0) {
            newState = ((MarsRootBlock)((Object)NorthstarBlocks.MARS_ROOTS.get())).m_49966_();
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = MarsRootBlock.getPropertyForFace(direction);
            if (!((Boolean)newState.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = MarsRootBlock.canSupportAtFace((BlockGetter)level, pos, direction);
            if (!flag) {
                flag = (newState.m_60713_((Block)NorthstarBlocks.MARS_ROOTS.get()) || newState.m_60713_((Block)NorthstarBlocks.GLOWING_MARS_ROOTS.get())) && (Boolean)newState.m_61143_((Property)booleanproperty) != false;
            }
            newState = (BlockState)newState.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
            if (flag) continue;
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return newState;
    }

    private BlockState getUpdatedState(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        BlockState blockstate = null;
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = MarsRootBlock.getPropertyForFace(direction);
            if (!((Boolean)pState.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = MarsRootBlock.canSupportAtFace(pLevel, pPos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = pLevel.m_8055_(blockpos);
                }
                flag = blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            pState = (BlockState)pState.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return pState;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState blockstate = this.getUpdatedState(pState, (BlockGetter)pLevel, pCurrentPos);
        return !this.hasFaces(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    private boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    private int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)pState.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private static boolean canSupportAtFace(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        if (MarsRootBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(pDirection);
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return (blockstate.m_60713_((Block)NorthstarBlocks.MARS_ROOTS.get()) || blockstate.m_60713_((Block)NorthstarBlocks.GLOWING_MARS_ROOTS.get())) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public static BooleanProperty getPropertyForFace(Direction pFace) {
        return PROPERTY_BY_DIRECTION.get(pFace);
    }

    public MultifaceSpreader m_213612_() {
        return this.spreader;
    }
}

