/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.google.gson.JsonObject;
import com.lightning.northstar.block.tech.ice_box.IceBoxBlockEntity;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FreezingRecipe
extends ProcessingRecipe<Container> {
    protected int minTemperature;
    protected int maxTemperature;

    public static boolean match(IceBoxBlockEntity icebox, Recipe<?> recipe) {
        boolean matchFluid;
        if (!(recipe instanceof FreezingRecipe)) {
            return false;
        }
        FreezingRecipe r = (FreezingRecipe)recipe;
        boolean matchItem = r.results.isEmpty() || icebox.filtering.test(((ProcessingOutput)r.results.get(0)).getStack());
        boolean bl = matchFluid = r.fluidResults.isEmpty() || icebox.filtering.test((FluidStack)r.fluidResults.get(0));
        if (!matchItem && !matchFluid) {
            return false;
        }
        return FreezingRecipe.apply(icebox, recipe, true);
    }

    public static boolean apply(IceBoxBlockEntity icebox, Recipe<?> recipe) {
        return FreezingRecipe.apply(icebox, recipe, false);
    }

    private static boolean apply(IceBoxBlockEntity icebox, Recipe<?> recipe, boolean test) {
        NonNullList nonNullList;
        SmartInventory availableItems = icebox.inputInventory;
        IFluidHandler availableFluids = (IFluidHandler)icebox.inputTank.getCapability().orElse(null);
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe r = (ProcessingRecipe)recipe;
            nonNullList = r.getFluidIngredients();
        } else {
            nonNullList = List.of();
        }
        NonNullList fluidIngredients = nonNullList;
        for (boolean simulate : Iterate.trueAndFalse) {
            Object ingredient2;
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Object ingredient2 : ingredients) {
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient2.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            ingredient2 = fluidIngredients.iterator();
            block3: while (ingredient2.hasNext()) {
                FluidIngredient fluidIngredient = (FluidIngredient)ingredient2.next();
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected && !simulate) {
                ((SmartFluidTankBehaviour)icebox.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)icebox.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate) {
                if (recipe instanceof FreezingRecipe) {
                    FreezingRecipe r = (FreezingRecipe)recipe;
                    recipeOutputItems.addAll(r.rollResults());
                    recipeOutputFluids.addAll((Collection<FluidStack>)r.getFluidResults());
                    recipeOutputItems.addAll((Collection<ItemStack>)r.m_7457_((Container)icebox.getInputInventory()));
                } else {
                    recipeOutputItems.add(recipe.m_8043_(icebox.m_58904_().m_9598_()));
                    if (recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        recipeOutputItems.addAll((Collection<ItemStack>)craftingRecipe.m_7457_((Container)new DummyCraftingContainer((IItemHandler)availableItems, extractedItemsFromSlot)));
                    }
                }
            }
            if (icebox.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public FreezingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)NorthstarRecipeTypes.FREEZING, params);
        if (params instanceof Params) {
            Params p = (Params)params;
            this.minTemperature = p.minTemperature;
            this.maxTemperature = p.maxTemperature;
        }
    }

    public boolean isTemperatureWithinRange(float temperature) {
        return temperature >= (float)this.minTemperature && temperature <= (float)this.maxTemperature;
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public int getMinTemperature() {
        return this.minTemperature;
    }

    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    public boolean m_5818_(Container inv, @Nonnull Level worldIn) {
        return false;
    }

    public static class Params
    extends ProcessingRecipeBuilder.ProcessingRecipeParams {
        protected int minTemperature = Integer.MIN_VALUE;
        protected int maxTemperature = Integer.MAX_VALUE;

        public Params(ResourceLocation id) {
            super(id);
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Serializer
    extends ProcessingRecipeSerializer<FreezingRecipe> {
        public Serializer() {
            super(FreezingRecipe::new);
        }

        protected FreezingRecipe readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FreezingRecipe recipe = (FreezingRecipe)super.readFromBuffer(recipeId, buffer);
            recipe.minTemperature = buffer.m_130242_();
            recipe.maxTemperature = buffer.m_130242_();
            return recipe;
        }

        protected void writeToBuffer(FriendlyByteBuf buffer, FreezingRecipe recipe) {
            super.writeToBuffer(buffer, (ProcessingRecipe)recipe);
            buffer.m_130130_(recipe.minTemperature);
            buffer.m_130130_(recipe.maxTemperature);
        }

        protected FreezingRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
            FreezingRecipe recipe = (FreezingRecipe)super.readFromJson(recipeId, json);
            recipe.minTemperature = GsonHelper.m_13824_((JsonObject)json, (String)"minTemperature", (int)Integer.MIN_VALUE);
            recipe.maxTemperature = GsonHelper.m_13824_((JsonObject)json, (String)"maxTemperature", (int)Integer.MAX_VALUE);
            return recipe;
        }

        protected void writeToJson(JsonObject json, FreezingRecipe recipe) {
            super.writeToJson(json, (ProcessingRecipe)recipe);
            if (recipe.minTemperature != Integer.MIN_VALUE) {
                json.addProperty("minTemperature", (Number)recipe.minTemperature);
            }
            if (recipe.maxTemperature != Integer.MAX_VALUE) {
                json.addProperty("maxTemperature", (Number)recipe.maxTemperature);
            }
        }
    }
}

