/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.block.tech.ice_box.IceBoxBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class IceBoxBlock
extends Block
implements IBE<IceBoxBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61373_;

    public IceBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING}));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> {
            if (!heldItem.m_41619_()) {
                if (FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)heldItem)) {
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41720_().equals(Items.f_41902_) && !be.getCapability(ForgeCapabilities.FLUID_HANDLER).map(iFluidHandler -> iFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY).isEmpty()) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            IItemHandlerModifiable inv = (IItemHandlerModifiable)be.itemCapability.orElse((Object)new ItemStackHandler(1));
            boolean success = false;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.m_41619_()) continue;
                player.m_150109_().m_150079_(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.f_41583_);
                success = true;
            }
            if (success) {
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + level.f_46441_.m_188501_());
            }
            return InteractionResult.SUCCESS;
        });
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        super.m_5548_(level, entity);
        if (!NorthstarBlocks.ICE_BOX.has(level.m_8055_(entity.m_20183_()))) {
            return;
        }
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!entity.m_6084_()) {
            return;
        }
        this.withBlockEntityDo(level, entity.m_20183_(), be -> {
            be.inputInventory.withMaxStackSize(64);
            ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)be.inputInventory, (ItemStack)itemEntity.m_32055_().m_41777_(), (boolean)false);
            be.inputInventory.withMaxStackSize(64);
            if (insertItem.m_41619_()) {
                itemEntity.m_146870_();
                return;
            }
            itemEntity.m_32045_(insertItem);
        });
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return AllShapes.BASIN_RAYTRACE_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.BASIN_BLOCK_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (ctx instanceof EntityCollisionContext && ((EntityCollisionContext)ctx).m_193113_() instanceof ItemEntity) {
            return AllShapes.BASIN_COLLISION_SHAPE;
        }
        return this.m_5940_(state, level, pos, ctx);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)level, pos).map(IceBoxBlockEntity::getInputInventory).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    public Class<IceBoxBlockEntity> getBlockEntityClass() {
        return IceBoxBlockEntity.class;
    }

    public BlockEntityType<? extends IceBoxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.ICE_BOX.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

