/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_filler;

import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlock;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.NorthstarOxygen;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class OxygenFillerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public int airLevel;
    public int airTimer;
    private boolean hasStopped = false;
    private int audioTick = 0;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    SmartFluidTankBehaviour tank;
    public Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
        }
    };
    protected ItemStackHandler inventory = new ItemStackHandler();

    public OxygenFillerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory}));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void tick() {
        super.tick();
        ItemStack item = this.container.m_8020_(0);
        Fluid fluid = this.tank.getPrimaryHandler().getFluid().getFluid();
        int increment = 2;
        if (item.m_204117_(NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.tag) && NorthstarOxygen.isOxygen(fluid)) {
            CompoundTag tag = item.m_41784_();
            int currentOxy = tag.m_128451_("Oxygen");
            while (currentOxy + increment > 1800) {
                --increment;
            }
            if ((increment = Math.max(increment, 0)) == 0 && !this.hasStopped) {
                AllSoundEvents.CONFIRM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.4f, 0.0f, true);
                this.hasStopped = true;
            } else if (increment != 0) {
                this.hasStopped = false;
                ++this.audioTick;
                if (this.f_58857_.f_46443_) {
                    if (this.audioTick % 13 == 0) {
                        BlockPos pos = this.m_58899_();
                        this.f_58857_.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)NorthstarSounds.AIRFLOW.get(), SoundSource.BLOCKS, 0.5f, 0.0f, false);
                    }
                    Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.f_58858_);
                    Vec3 v = VecHelper.offsetRandomly((Vec3)centerOf, (RandomSource)this.f_58857_.f_46441_, (float)0.65f);
                    Vec3 m = centerOf.m_82546_(v);
                    if (this.f_58857_.f_46441_.m_188499_()) {
                        this.f_58857_.m_7106_((ParticleOptions)new AirParticleData(1.0f, 0.05f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
                    }
                }
            }
            int newOxyAmount = Mth.m_14045_((int)increment, (int)0, (int)this.tank.getPrimaryHandler().getFluidAmount());
            int newoxy = currentOxy + newOxyAmount;
            tag.m_128405_("Oxygen", newoxy);
            item.m_41751_(tag);
            this.tank.getPrimaryHandler().drain(new FluidStack(fluid, newOxyAmount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Air", this.airLevel);
        compound.m_128405_("Timer", this.airTimer);
        compound.m_128365_("item", (Tag)this.container.m_8020_(0).m_41739_(new CompoundTag()));
    }

    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        compound.m_128365_("item", (Tag)this.container.m_8020_(0).m_41739_(new CompoundTag()));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airLevel = compound.m_128451_("Air");
        this.airTimer = compound.m_128451_("Timer");
        this.container.m_6836_(0, ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.oxygen_filler", (Object[])new Object[0]).forGoggles(tooltip);
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.getFluid().getFluidType().isAir()) {
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            Lang.translate((String)"gui.goggles.empty", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)this.tank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        ItemStack itemStack = this.container.m_8020_(0);
        if (!itemStack.m_41619_()) {
            Lang.builder().add(Lang.number((double)itemStack.m_41613_()).style(ChatFormatting.GRAY)).text(ChatFormatting.DARK_GRAY, "x ").add(Lang.itemName((ItemStack)itemStack).style(ChatFormatting.GRAY)).forGoggles(tooltip, 1);
            CompoundTag thing = itemStack.m_41783_();
            int currentOxy = thing.m_128451_("Oxygen");
            if (currentOxy != 0) {
                Lang.builder().add(Lang.number((double)currentOxy).style(ChatFormatting.GRAY)).add(mb).style(ChatFormatting.GRAY).forGoggles(tooltip, 2);
            }
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == ((Direction)this.m_58900_().m_61143_(OxygenFillerBlock.HORIZONTAL_FACING)).m_122424_()) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

