/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.temperature_regulator.BaseTemperatureRegulator;
import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlock;
import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorEditPacket;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.util.TemperatureUnit;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangNumberFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TemperatureRegulatorScreen
extends AbstractSimiScreen {
    private static final ResourceLocation BACKGROUND = Northstar.asResource("textures/gui/temperature_regulator.png");
    private final BaseTemperatureRegulator regulator;
    private final int entityId;
    private final BlockPos pos;

    public TemperatureRegulatorScreen(BaseTemperatureRegulator regulator, int entityId, BlockPos pos) {
        super((Component)((TemperatureRegulatorBlock)((Object)NorthstarBlocks.TEMPERATURE_REGULATOR.get())).m_49954_());
        this.regulator = regulator;
        this.entityId = entityId;
        this.pos = pos;
        this.setWindowSize(204, entityId == -1 ? 40 : 60);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        ScrollInput sizeX = this.addScrollInput(new ScrollInput(x + 29, y + 11, 25, 18), this.regulator.sizeX, "Width (X)");
        ScrollInput sizeY = this.addScrollInput(new ScrollInput(x + 58, y + 11, 25, 18), this.regulator.sizeY, "Height (Y)");
        ScrollInput sizeZ = this.addScrollInput(new ScrollInput(x + 87, y + 11, 25, 18), this.regulator.sizeZ, "Depth (Z)");
        boolean[] limit = new boolean[]{this.regulator.bounds.minX == Integer.MIN_VALUE};
        IconButton fill = new IconButton(x + 7, y + 11, (ScreenElement)AllIcons.I_NONE);
        fill.setToolTip((Component)Component.m_237113_((String)"Enable limits"));
        fill.withCallback(() -> {
            limit[0] = !limit[0];
            fill.setIcon((ScreenElement)(limit[0] ? AllIcons.I_CONFIRM : AllIcons.I_DISABLE));
            sizeX.f_93623_ = limit[0];
            sizeY.f_93623_ = limit[0];
            sizeZ.f_93623_ = limit[0];
        });
        fill.m_5716_(0.0, 0.0);
        this.m_142416_((GuiEventListener)fill);
        TemperatureUnit unit = (TemperatureUnit)((Object)NorthstarConfigs.client().temperatureUnit.get());
        ScrollInput temperature = this.addScrollInput(new ScrollInput(x + 129, y + 11, 46, 18), 0, "Temperature").addHint(Component.m_237115_((String)"northstar.gui.temperature_regulator.step").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY})).withRange((int)unit.fromCelsius(-273.0f), (int)unit.fromCelsius(1501.0f)).setState((int)unit.fromCelsius(this.regulator.temperature)).withStepFunction(s -> s.shift ? 100 : (s.control ? 20 : 1)).format(i -> Component.m_237113_((String)(LangNumberFormat.format((double)i.intValue()) + unit.symbol)));
        temperature.onChanged();
        IconButton confirm = new IconButton(x + 179, y + 11, (ScreenElement)AllIcons.I_CONFIRM);
        confirm.setToolTip((Component)Component.m_237115_((String)"northstar.generic.confirm"));
        confirm.withCallback(() -> {
            NorthstarPackets.getChannel().sendToServer((Object)new TemperatureRegulatorEditPacket(this.entityId, this.pos, (int)unit.toCelsius(temperature.getState()), limit[0], sizeX.getState(), sizeY.getState(), sizeZ.getState()));
            this.m_7379_();
        });
        this.m_142416_((GuiEventListener)confirm);
    }

    private ScrollInput addScrollInput(ScrollInput input, int value, String name) {
        Label label = new Label(0, input.m_252907_() + 6, (Component)Component.m_237119_()).withShadow();
        input.withRange(1, 6).calling(i -> label.m_252865_(input.m_252754_() + input.m_5711_() / 2 - this.f_96547_.m_92852_((FormattedText)label.text) / 2)).writingTo(label).titled(Component.m_237113_((String)name)).setState(value).onChanged();
        this.m_142416_((GuiEventListener)label);
        this.m_142416_((GuiEventListener)input);
        return input;
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.entityId == -1) {
            graphics.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.windowWidth, this.windowHeight, 256, 64);
        } else {
            graphics.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.windowWidth, 36, 256, 64);
            graphics.m_280163_(BACKGROUND, this.guiLeft, this.guiTop + 36, 0.0f, 40.0f, this.windowWidth, 24, 256, 64);
            MutableComponent status = this.regulator.sealer.hasLeak() ? Component.m_237115_((String)"northstar.gui.goggles.sealer.area_too_big").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"northstar.gui.oxygen_sealer.sealed").m_130940_(ChatFormatting.GREEN);
            MutableComponent line1 = Component.m_237115_((String)"northstar.generic.status").m_7220_((Component)status);
            MutableComponent line2 = this.regulator.sealer.hasLeak() ? NorthstarLang.translate("gui.goggles.sealer.max_sealed_contraption", new Object[0]).add(Lang.number((double)((Integer)NorthstarConfigs.server().temperatureRegulatorMaxContraptionSealed.get()).intValue()).style(ChatFormatting.AQUA)).text(" blocks").component() : NorthstarLang.translate("gui.goggles.sealer.blocks_filled", new Object[0]).add(Lang.number((double)this.regulator.sealer.getSealedBlockCount()).style(ChatFormatting.AQUA)).component();
            graphics.m_280430_(this.f_96547_, (Component)line1, this.guiLeft + 5, this.guiTop + 34, -1);
            graphics.m_280430_(this.f_96547_, (Component)line2, this.guiLeft + 5, this.guiTop + 44, -1);
        }
    }
}

