/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption;

import com.lightning.northstar.content.NorthstarRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

public record FuelType(HolderSet<Fluid> fluids, float gjPerMb, int combustionEngineEfficiency, float combustionEngineRpm) {
    public static final Codec<FuelType> CODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256808_).fieldOf("fluids").forGetter(FuelType::fluids), (App)Codec.FLOAT.fieldOf("gj_per_mb").forGetter(FuelType::gjPerMb), (App)Codec.INT.fieldOf("combustion_engine_use").forGetter(FuelType::combustionEngineEfficiency), (App)Codec.FLOAT.fieldOf("combustion_engine_rpm").forGetter(FuelType::combustionEngineRpm)).apply((Applicative)i, FuelType::new));
    private static final Map<Fluid, FuelType> FUEL_CACHE = new ConcurrentHashMap<Fluid, FuelType>();

    @ApiStatus.Internal
    public static void recacheFuels(RegistryAccess registryAccess) {
        FUEL_CACHE.clear();
        Registry fuels = registryAccess.m_175515_(NorthstarRegistries.FUEL);
        for (Fluid fluid : registryAccess.m_175515_(Registries.f_256808_)) {
            fuels.m_123024_().filter(fuel -> fuel.supports(fluid)).findFirst().ifPresent(fuel -> FUEL_CACHE.put(fluid, (FuelType)fuel));
        }
    }

    public static FuelType getFuelType(Fluid fluid) {
        return FUEL_CACHE.get(fluid);
    }

    public boolean supports(Fluid fluid) {
        return fluid.m_76145_().m_205072_(this.fluids);
    }
}

