/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlockEntity;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RocketHandler {
    public static final List<RocketContraptionEntity> ROCKETS = new ArrayList<RocketContraptionEntity>();
    public static List<Pair<Level, BlockPos>> TICKET_QUEUE = new ArrayList<Pair<Level, BlockPos>>();
    public static HashMap<Pair<UUID, BlockPos>, Integer> CONTROL_QUEUE = new HashMap();
    public static long eventTickNumber;
    public static long eventTickNumberCheck;
    private static UUID pilotID;
    static int pp;
    public static final int DIMENSION_CHANGE_HEIGHT = 1750;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        eventTickNumber = event.level.m_46467_();
        if (!CONTROL_QUEUE.isEmpty() && eventTickNumber > eventTickNumberCheck) {
            HashMap<Pair<UUID, BlockPos>, Integer> destroy = new HashMap<Pair<UUID, BlockPos>, Integer>();
            for (Map.Entry<Pair<UUID, BlockPos>, Integer> entry : CONTROL_QUEUE.entrySet()) {
                RocketContraptionEntity rocket;
                Player player;
                if (entry.getKey().getFirst() == null || (player = event.level.m_46003_((UUID)entry.getKey().getFirst())) == null || (rocket = (RocketContraptionEntity)event.level.m_6815_(entry.getValue().intValue())) == null) continue;
                if (rocket.getControllingPlayer().isPresent() && rocket.getControllingPlayer().get() == player.m_20148_()) {
                    destroy.put(entry.getKey(), entry.getValue());
                    continue;
                }
                rocket.handlePlayerInteraction(player, (BlockPos)entry.getKey().getSecond(), Direction.NORTH, InteractionHand.MAIN_HAND);
                destroy.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Integer> entry : destroy.entrySet()) {
                CONTROL_QUEUE.remove(entry.getKey(), entry.getValue());
            }
        }
        if (event.level.f_46443_) {
            return;
        }
        if (eventTickNumber > eventTickNumberCheck && !TICKET_QUEUE.isEmpty()) {
            ArrayList<Pair> DELETE_QUEUE = new ArrayList<Pair>();
            for (Pair pair : TICKET_QUEUE) {
                BlockEntity blockEntity;
                if (event.level.m_46472_() != ((Level)pair.getFirst()).m_46472_() || !((blockEntity = ((Level)pair.getFirst()).m_7702_((BlockPos)pair.getSecond())) instanceof RocketStationBlockEntity)) continue;
                RocketStationBlockEntity rsbe = (RocketStationBlockEntity)blockEntity;
                rsbe.container.m_6836_(0, new ItemStack((ItemLike)Blocks.f_50016_.m_5456_()));
                DELETE_QUEUE.add(pair);
            }
            for (Pair pair : DELETE_QUEUE) {
                TICKET_QUEUE.remove(pair);
            }
        }
    }

    private static CompoundTag saveEntityData(Entity passenger) {
        CompoundTag nbt = new CompoundTag();
        return passenger.m_20240_(nbt);
    }

    private static void loadEntityData(Entity passenger, CompoundTag nbt, Map<UUID, Vec3> shipOffsetMap) {
        passenger.m_20258_(nbt);
        if (shipOffsetMap == null || !shipOffsetMap.containsKey(passenger.m_20148_())) {
            Northstar.LOGGER.warn("Passenger {} DOES NOT has a ship offset", (Object)passenger);
        }
    }

    public static void deleteTicket(Level level, BlockPos pos) {
        TICKET_QUEUE.add((Pair<Level, BlockPos>)Pair.of((Object)level, (Object)pos.m_7494_()));
        eventTickNumberCheck = eventTickNumber + 3L;
    }

    public static boolean isInRocket(Entity entity) {
        return RocketHandler.getRocketThatContainsEntity(entity) != null;
    }

    public static RocketContraptionEntity getRocketThatContainsEntity(Entity entity) {
        for (RocketContraptionEntity rocket : ROCKETS) {
            if (!rocket.getEntitiesWithinContraption().contains(entity)) continue;
            return rocket;
        }
        return null;
    }

    public static void register() {
    }

    static {
        pp = 0;
    }
}

