/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.projectiles.VenusScorpionSpit;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusScorpionEntity
extends Monster
implements GeoAnimatable,
RangedAttackMob {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int spitAnim = 0;

    public VenusScorpionEntity(EntityType<? extends VenusScorpionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<VenusScorpionEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.spitAnim > 0) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("spit"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public static boolean scorpionSpawnRules(EntityType<VenusScorpionEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.m_8055_(pos.m_7495_());
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag);
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.spitAnim = 10;
        }
        super.m_7822_(pId);
    }

    public void m_8119_() {
        if (this.spitAnim > 0) {
            --this.spitAnim;
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_5448_() != null) {
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        super.m_8024_();
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.VENUS_SCORPION_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.VENUS_SCORPION_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.VENUS_SCORPION_DEATH.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 3.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new ShootAcidGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new StareAtTargetGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true));
        super.m_8099_();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
    }

    static class ShootAcidGoal
    extends Goal {
        private final VenusScorpionEntity shooter;
        public int chargeTime;

        public ShootAcidGoal(VenusScorpionEntity shooter) {
            this.shooter = shooter;
        }

        public boolean m_8036_() {
            return this.shooter.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.shooter.m_5448_();
            if (livingentity != null && !this.shooter.m_21573_().m_26572_()) {
                if (livingentity.m_20280_((Entity)this.shooter) < 4096.0 && this.shooter.m_142582_((Entity)livingentity)) {
                    Level level = this.shooter.m_9236_();
                    ++this.chargeTime;
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.shooter.m_20252_(1.0f);
                        VenusScorpionSpit acidspit = new VenusScorpionSpit(level, this.shooter);
                        double newX = this.shooter.m_5448_().m_20185_() - this.shooter.m_20185_();
                        double newY = this.shooter.m_5448_().m_20227_(0.3333333333333333) - acidspit.m_20186_();
                        double newZ = this.shooter.m_5448_().m_20189_() - this.shooter.m_20189_();
                        double newThing = Math.sqrt(newX * newX + newZ * newZ) * (double)0.2f;
                        this.shooter.spitAnim = 10;
                        level.m_7605_((Entity)this.shooter, (byte)4);
                        acidspit.m_6686_(newX, newY + newThing, newZ, 1.5f, 10.0f);
                        acidspit.m_6034_(this.shooter.m_20185_() + vec3.f_82479_, this.shooter.m_20227_(0.5), acidspit.m_20189_() + vec3.f_82481_);
                        level.m_7967_((Entity)acidspit);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
        }
    }

    static class StareAtTargetGoal
    extends Goal {
        private final VenusScorpionEntity shooter;

        public StareAtTargetGoal(VenusScorpionEntity pShooter) {
            this.shooter = pShooter;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.shooter.m_5448_() == null) {
                Vec3 vec3 = this.shooter.m_20184_();
                this.shooter.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.shooter.f_20883_ = this.shooter.m_146908_();
            } else {
                LivingEntity livingentity = this.shooter.m_5448_();
                if (livingentity.m_20280_((Entity)this.shooter) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.shooter.m_20185_();
                    double d2 = livingentity.m_20189_() - this.shooter.m_20189_();
                    this.shooter.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.shooter.f_20883_ = this.shooter.m_146908_();
                }
            }
        }
    }
}

