/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CompassItem.class})
public class CompassMixin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_LODESTONE_POS = "LodestonePos";
    private static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    private static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void useOn(UseOnContext pContext, CallbackInfoReturnable<InteractionResult> info) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (level.m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.ROCKET_STATION.get())) {
            boolean flag;
            level.m_5594_((Player)null, blockpos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
            Player player = pContext.m_43723_();
            ItemStack itemstack = pContext.m_43722_();
            boolean bl = flag = !player.m_150110_().f_35937_ && itemstack.m_41613_() == 1;
            if (flag) {
                this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockpos, itemstack.m_41784_());
            } else {
                ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42522_, 1);
                CompoundTag compoundtag = itemstack.m_41782_() ? itemstack.m_41783_().m_6426_() : new CompoundTag();
                itemstack1.m_41751_(compoundtag);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundtag);
                if (!player.m_150109_().m_36054_(itemstack1)) {
                    player.m_36176_(itemstack1, false);
                }
            }
            info.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected, CallbackInfo info) {
        if (!pLevel.f_46443_ && CompassMixin.isLodestoneCompass2(pStack)) {
            BlockPos blockpos;
            CompoundTag compoundtag = pStack.m_41784_();
            if (compoundtag.m_128441_(TAG_LODESTONE_TRACKED) && !compoundtag.m_128471_(TAG_LODESTONE_TRACKED)) {
                return;
            }
            Optional<ResourceKey<Level>> optional = CompassMixin.getLodestoneDimension2(compoundtag);
            if (optional.isPresent() && optional.get() == pLevel.m_46472_() && compoundtag.m_128441_(TAG_LODESTONE_POS) && pLevel.m_46739_(blockpos = NbtUtils.m_129239_((CompoundTag)compoundtag.m_128469_(TAG_LODESTONE_POS))) && ((ServerLevel)pLevel).m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.ROCKET_STATION.get())) {
                info.cancel();
            }
        }
    }

    @Nullable
    private static GlobalPos getLodestonePosition2(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.m_128441_(TAG_LODESTONE_POS);
        boolean flag1 = p_220022_.m_128441_(TAG_LODESTONE_DIMENSION);
        if (flag && flag1 && (optional = CompassMixin.getLodestoneDimension2(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)p_220022_.m_128469_(TAG_LODESTONE_POS));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    private static Optional<ResourceKey<Level>> getLodestoneDimension2(CompoundTag pCompoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)pCompoundTag.m_128423_(TAG_LODESTONE_DIMENSION)).result();
    }

    private static boolean isLodestoneCompass2(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_(TAG_LODESTONE_DIMENSION) || compoundtag.m_128441_(TAG_LODESTONE_POS));
    }

    private void addLodestoneTags(ResourceKey<Level> pLodestoneDimension, BlockPos pLodestonePos, CompoundTag pCompoundTag) {
        pCompoundTag.m_128365_(TAG_LODESTONE_POS, (Tag)NbtUtils.m_129224_((BlockPos)pLodestonePos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, pLodestoneDimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_40731_ -> pCompoundTag.m_128365_(TAG_LODESTONE_DIMENSION, p_40731_));
        pCompoundTag.m_128379_(TAG_LODESTONE_TRACKED, true);
    }
}

